"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateEditPipelineLink = CreateEditPipelineLink;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _translations = require("../../../../../../../common/translations");
var _utils = require("../../../../../../utils");
var _hooks = require("../../../../../../hooks");
var _mitigation_accordion = require("../mitigation_accordion");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/quality_issue_flyout/degraded_field/possible_mitigations/manual/pipeline_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function CreateEditPipelineLink({
  areIntegrationAssetsAvailable
}) {
  const {
    services: {
      share: {
        url: {
          locators
        }
      }
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    datasetDetails
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const {
    type,
    name
  } = datasetDetails;
  const pipelineName = areIntegrationAssetsAvailable ? `${type}-${name}@custom` : `${type}@custom`;
  const ingestPipelineLocator = locators.get('INGEST_PIPELINES_APP_LOCATOR');
  const pipelineUrl = ingestPipelineLocator === null || ingestPipelineLocator === void 0 ? void 0 : ingestPipelineLocator.useUrl({
    pipelineId: pipelineName,
    page: 'pipelines_list'
  }, {}, [pipelineName]);
  const onClickHandler = (0, _react.useCallback)(() => {
    (0, _eui.copyToClipboard)(pipelineName);
  }, [pipelineName]);
  return /*#__PURE__*/_react.default.createElement(_mitigation_accordion.MitigationAccordion, {
    title: _translations.otherMitigationsCustomIngestPipeline,
    isLoading: false,
    dataTestSubjPrefix: "datasetQualityManualMitigationsPipeline",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.details.degradedField.possibleMitigation.otherMitigationsCustomPipelineText1",
    defaultMessage: "{lineNumber} Copy the following pipeline name",
    values: {
      lineNumber: /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.datasetQuality.editPipeline.strong.Label', {
        defaultMessage: '1.'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "copy",
      "data-test-subj": "datasetQualityManualMitigationsPipelineNameCopyButton",
      onClick: onClickHandler,
      "aria-label": _translations.manualMitigationCustomPipelineCopyPipelineNameAriaText,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }),
    readOnly: true,
    "aria-label": _translations.manualMitigationCustomPipelineCopyPipelineNameAriaText,
    value: pipelineName,
    "data-test-subj": "datasetQualityManualMitigationsPipelineName",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.details.degradedField.possibleMitigation.otherMitigationsCustomPipelineText2",
    defaultMessage: "{lineNumber} Using the name you copied, {createEditPipelineLink}",
    values: {
      lineNumber: /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.datasetQuality.editPipeline.strong.Label', {
        defaultMessage: '2.'
      })),
      createEditPipelineLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "datasetQualityManualMitigationsPipelineLink",
        "data-test-url": pipelineUrl,
        href: pipelineUrl,
        target: "_blank",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 13
        }
      }, _translations.manualMitigationCustomPipelineCreateEditPipelineLink)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }));
}