"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SparkPlot = SparkPlot;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _chartsTheme = require("@kbn/charts-theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/common/spark_plot.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SparkPlot({
  valueLabel,
  isLoading,
  series
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }, valueLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SparkPlotItem, {
    isLoading: isLoading,
    series: series,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 9
    }
  })));
}
function SparkPlotItem({
  isLoading,
  series
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const chartSize = {
    height: euiTheme.size.l,
    width: '80px'
  };
  const commonStyle = {
    ...chartSize,
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center'
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: commonStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }));
  }
  if (hasValidTimeSeries(series)) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        padding: 1,
        height: '100%'
      },
      "data-test-subj": "datasetQualitySparkPlot",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
      size: chartSize,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
      showLegend: false,
      locale: _i18n.i18n.getLocale(),
      baseTheme: chartBaseTheme,
      theme: {
        background: {
          color: 'transparent'
        }
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
      id: "areaseries",
      xScaleType: _charts.ScaleType.Linear,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: "x",
      yAccessors: ['y'],
      data: series,
      color: euiTheme.colors.vis.euiColorVis6,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
      type: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: commonStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "visLine",
    color: euiTheme.colors.mediumShade,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }));
}
function hasValidTimeSeries(series) {
  return !!(series !== null && series !== void 0 && series.some(point => point.y !== 0));
}