"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatsESQLEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/esql/public");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/index_data_visualizer/embeddables/field_stats/field_stats_esql_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldStatsESQLEditor = ({
  canEditTextBasedQuery = true,
  query,
  setQuery,
  onQuerySubmit,
  disableSubmitAction = false
}) => {
  const prevQuery = (0, _react.useRef)(query);
  const [isVisualizationLoading, setIsVisualizationLoading] = (0, _react.useState)(false);
  const onTextLangQuerySubmit = (0, _react.useCallback)(async (q, abortController) => {
    if (q && onQuerySubmit) {
      setIsVisualizationLoading(true);
      await onQuerySubmit(q, abortController);
      setIsVisualizationLoading(false);
    }
  }, [onQuerySubmit]);
  if (!canEditTextBasedQuery) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "InlineEditingESQLEditor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ESQLLangEditor, {
    query: query,
    onTextLangQueryChange: q => {
      setQuery(q);
      prevQuery.current = q;
    },
    editorIsInline: true,
    hideRunQueryText: true,
    onTextLangQuerySubmit: onTextLangQuerySubmit,
    allowQueryCancellation: false,
    disableSubmitAction: disableSubmitAction,
    isLoading: isVisualizationLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }));
};
exports.FieldStatsESQLEditor = FieldStatsESQLEditor;