"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DistinctValues = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _fieldTypes = require("@kbn/field-types");
var _constants = require("../../../../../../../common/constants");
var _kibana_context = require("../../../../../kibana_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/components/field_data_row/distinct_values.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DistinctValues = ({
  showIcon,
  config
}) => {
  const {
    stats,
    type
  } = config;
  const {
    services: {
      data: {
        fieldFormats
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const cardinality = stats === null || stats === void 0 ? void 0 : stats.cardinality;
  if (cardinality === undefined || stats === undefined) return null;
  const {
    sampleCount
  } = stats;
  const tooltipContent = type === _constants.SUPPORTED_FIELD_TYPES.TEXT ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.sampledCardinalityForTextFieldsMsg",
    defaultMessage: "The cardinality for text fields is calculated from a sample of {sampledDocumentsFormatted} {sampledDocuments, plural, one {record} other {records}}.",
    values: {
      sampledDocuments: sampleCount,
      sampledDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 13
        }
      }, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(sampleCount))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }) : null;
  const icon = showIcon ? type === _constants.SUPPORTED_FIELD_TYPES.TEXT ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: tooltipContent,
    type: "partial",
    size: 'm',
    className: 'columnHeader__icon',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "database",
    size: 'm',
    className: 'columnHeader__icon',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }) : null;
  const content = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 19
    }
  }, cardinality);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, icon, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, content));
};
exports.DistinctValues = DistinctValues;