"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerFieldTypesFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _fieldUtils = require("@kbn/field-utils");
var _field_types_help_popover = require("./field_types_help_popover");
var _multi_select_picker = require("../multi_select_picker");
var _field_type_icon = require("../field_type_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/field_types_filter/field_types_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataVisualizerFieldTypesFilter = ({
  fields,
  setVisibleFieldTypes,
  visibleFieldTypes
}) => {
  const fieldNameTitle = (0, _react.useMemo)(() => _i18n.i18n.translate('xpack.dataVisualizer.fieldTypeSelect', {
    defaultMessage: 'Field type'
  }), []);
  const options = (0, _react.useMemo)(() => {
    const fieldTypesTracker = new Set();
    const fieldTypes = [];
    fields.forEach(({
      type
    }) => {
      const label = (0, _fieldUtils.getFieldTypeName)(type);
      if (type !== undefined && !fieldTypesTracker.has(type) && label !== undefined) {
        fieldTypesTracker.add(type);
        fieldTypes.push({
          value: type,
          name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 51,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 52,
              columnNumber: 15
            }
          }, " ", label), type && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 54,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_field_type_icon.FieldTypeIcon, {
            type: type,
            tooltipEnabled: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 55,
              columnNumber: 19
            }
          })))
        });
      }
    });
    return fieldTypes;
  }, [fields]);
  return /*#__PURE__*/_react.default.createElement(_multi_select_picker.MultiSelectPicker, {
    title: fieldNameTitle,
    options: options,
    onChange: setVisibleFieldTypes,
    checkedOptions: visibleFieldTypes,
    dataTestSubj: 'dataVisualizerFieldTypeSelect',
    postfix: /*#__PURE__*/_react.default.createElement(_field_types_help_popover.FieldTypesHelpPopover, {
      fieldTypes: options.map(f => f.value),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 16
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  });
};
exports.DataVisualizerFieldTypesFilter = DataVisualizerFieldTypesFilter;