"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataUsagePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _config = require("./config");
var _routes = require("./routes");
var _common = require("../common");
var _app_context = require("./services/app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataUsagePlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "dataUsageContext", void 0);
    (0, _defineProperty2.default)(this, "config$", void 0);
    (0, _defineProperty2.default)(this, "configInitialValue", void 0);
    (0, _defineProperty2.default)(this, "cloud", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "kibanaBranch", void 0);
    (0, _defineProperty2.default)(this, "kibanaInstanceId", void 0);
    this.config$ = context.config.create();
    this.kibanaVersion = context.env.packageInfo.version;
    this.kibanaBranch = context.env.packageInfo.branch;
    this.kibanaInstanceId = context.env.instanceUuid;
    this.logger = context.logger;
    this.configInitialValue = context.config.get();
    const serverConfig = (0, _config.createConfig)(context);
    this.logger.get().debug('data usage plugin initialized');
    this.dataUsageContext = {
      config$: context.config.create(),
      configInitialValue: context.config.get(),
      logFactory: context.logger,
      get serverConfig() {
        return serverConfig;
      },
      kibanaVersion: context.env.packageInfo.version,
      kibanaBranch: context.env.packageInfo.branch,
      kibanaInstanceId: context.env.instanceUuid
    };
  }
  setup(coreSetup, pluginsSetup) {
    this.logger.get().debug('data usage plugin setup');
    this.cloud = pluginsSetup.cloud;
    pluginsSetup.features.registerElasticsearchFeature({
      id: _common.PLUGIN_ID,
      management: {
        data: [_common.PLUGIN_ID]
      },
      privileges: [{
        requiredClusterPrivileges: ['monitor'],
        ui: []
      }]
    });
    const router = coreSetup.http.createRouter();
    (0, _routes.registerDataUsageRoutes)(router, this.dataUsageContext);
    return {};
  }
  start(_coreStart, _pluginsStart) {
    _app_context.appContextService.start({
      configInitialValue: this.configInitialValue,
      config$: this.config$,
      kibanaVersion: this.kibanaVersion,
      kibanaBranch: this.kibanaBranch,
      kibanaInstanceId: this.kibanaInstanceId,
      cloud: this.cloud,
      logFactory: this.logger,
      serverConfig: this.dataUsageContext.serverConfig
    });
    return {};
  }
  stop() {
    this.logger.get().debug('Stopping data usage plugin');
  }
}
exports.DataUsagePlugin = DataUsagePlugin;