"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFiltersFromRangeSelectAction = createFiltersFromRangeSelectAction;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-views-plugin/public");
var _services = require("../../services");
var _query = require("../../query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getParameters = async event => {
  var _event$table$meta;
  const column = event.table.columns[event.column];
  // Handling of the ES|QL datatable
  if ((0, _esQuery.isOfAggregateQueryType)(event.query) || ((_event$table$meta = event.table.meta) === null || _event$table$meta === void 0 ? void 0 : _event$table$meta.type) === 'es_ql') {
    var _column$meta, _column$meta$sourcePa, _column$meta$type, _column$meta2, _column$meta3;
    const field = new _public.DataViewField({
      name: ((_column$meta = column.meta) === null || _column$meta === void 0 ? void 0 : (_column$meta$sourcePa = _column$meta.sourceParams) === null || _column$meta$sourcePa === void 0 ? void 0 : _column$meta$sourcePa.sourceField) || column.name,
      type: (_column$meta$type = (_column$meta2 = column.meta) === null || _column$meta2 === void 0 ? void 0 : _column$meta2.type) !== null && _column$meta$type !== void 0 ? _column$meta$type : 'unknown',
      esTypes: (_column$meta3 = column.meta) !== null && _column$meta3 !== void 0 && _column$meta3.esType ? [column.meta.esType] : undefined,
      searchable: true,
      aggregatable: false
    });
    return {
      field,
      indexPattern: undefined
    };
  }
  if (column.meta && 'sourceParams' in column.meta) {
    const {
      sourceField,
      ...aggConfigs
    } = column.meta.sourceParams;
    const indexPatternId = column.meta.sourceParams.indexPatternId || column.meta.sourceParams.indexPattern;
    const indexPattern = await (0, _services.getIndexPatterns)().get(indexPatternId);
    const aggConfigsInstance = (0, _services.getSearchService)().aggs.createAggConfigs(indexPattern, [aggConfigs]);
    const aggConfig = aggConfigsInstance.aggs[0];
    const field = aggConfig.params.field;
    return {
      field,
      indexPattern
    };
  }
  return {
    field: undefined,
    indexPattern: undefined
  };
};
async function createFiltersFromRangeSelectAction(event) {
  const column = event.table.columns[event.column];
  if (!column || !column.meta) {
    return [];
  }
  const {
    field,
    indexPattern
  } = await getParameters(event);
  if (!field || event.range.length <= 1) {
    return [];
  }
  const min = event.range[0];
  const max = (0, _lodash.last)(event.range);
  if (min === max) {
    return [];
  }
  const isDate = field.type === 'date';
  const range = {
    gte: isDate ? (0, _moment.default)(min).toISOString() : min,
    lt: isDate ? (0, _moment.default)(max).toISOString() : max
  };
  if (isDate) {
    range.format = 'strict_date_optional_time';
  }
  return (0, _query.mapAndFlattenFilters)([(0, _esQuery.buildRangeFilter)(field, range, indexPattern)]);
}