"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAggTypesFunctions = exports.getAggTypes = void 0;
var _buckets = _interopRequireWildcard(require("./buckets"));
var buckets = _buckets;
var _metrics = _interopRequireWildcard(require("./metrics"));
var metrics = _metrics;
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */
const getAggTypes = () => ({
  metrics: [{
    name: _metrics.METRIC_TYPES.COUNT,
    fn: metrics.getCountMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.AVG,
    fn: metrics.getAvgMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.SUM,
    fn: metrics.getSumMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.MEDIAN,
    fn: metrics.getMedianMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.SINGLE_PERCENTILE,
    fn: metrics.getSinglePercentileMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.SINGLE_PERCENTILE_RANK,
    fn: metrics.getSinglePercentileRankMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.MIN,
    fn: metrics.getMinMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.MAX,
    fn: metrics.getMaxMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.STD_DEV,
    fn: metrics.getStdDeviationMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.CARDINALITY,
    fn: metrics.getCardinalityMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.VALUE_COUNT,
    fn: metrics.getValueCountMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.PERCENTILES,
    fn: metrics.getPercentilesMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.PERCENTILE_RANKS,
    fn: metrics.getPercentileRanksMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.RATE,
    fn: metrics.getRateMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.TOP_HITS,
    fn: metrics.getTopHitMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.TOP_METRICS,
    fn: metrics.getTopMetricsMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.DERIVATIVE,
    fn: metrics.getDerivativeMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.CUMULATIVE_SUM,
    fn: metrics.getCumulativeSumMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.MOVING_FN,
    fn: metrics.getMovingAvgMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.SERIAL_DIFF,
    fn: metrics.getSerialDiffMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.AVG_BUCKET,
    fn: metrics.getBucketAvgMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.SUM_BUCKET,
    fn: metrics.getBucketSumMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.MIN_BUCKET,
    fn: metrics.getBucketMinMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.MAX_BUCKET,
    fn: metrics.getBucketMaxMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.FILTERED_METRIC,
    fn: metrics.getFilteredMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.GEO_BOUNDS,
    fn: metrics.getGeoBoundsMetricAgg
  }, {
    name: _metrics.METRIC_TYPES.GEO_CENTROID,
    fn: metrics.getGeoCentroidMetricAgg
  }],
  buckets: [{
    name: _buckets.BUCKET_TYPES.DATE_HISTOGRAM,
    fn: buckets.getDateHistogramBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.HISTOGRAM,
    fn: buckets.getHistogramBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.RANGE,
    fn: buckets.getRangeBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.DATE_RANGE,
    fn: buckets.getDateRangeBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.IP_PREFIX,
    fn: buckets.getIpPrefixBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.IP_RANGE,
    fn: buckets.getIpRangeBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.TERMS,
    fn: buckets.getTermsBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.MULTI_TERMS,
    fn: buckets.getMultiTermsBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.RARE_TERMS,
    fn: buckets.getRareTermsBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.FILTER,
    fn: buckets.getFilterBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.FILTERS,
    fn: buckets.getFiltersBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.SIGNIFICANT_TERMS,
    fn: buckets.getSignificantTermsBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.SIGNIFICANT_TEXT,
    fn: buckets.getSignificantTextBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.GEOTILE_GRID,
    fn: buckets.getGeoTitleBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.SAMPLER,
    fn: buckets.getSamplerBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.DIVERSIFIED_SAMPLER,
    fn: buckets.getDiversifiedSamplerBucketAgg
  }, {
    name: _buckets.BUCKET_TYPES.TIME_SERIES,
    fn: buckets.getTimeSeriesBucketAgg
  }]
});

/** @internal */
exports.getAggTypes = getAggTypes;
const getAggTypesFunctions = () => [buckets.aggFilter, buckets.aggFilters, buckets.aggSignificantTerms, buckets.aggSignificantText, buckets.aggIpPrefix, buckets.aggIpRange, buckets.aggDateRange, buckets.aggRange, buckets.aggGeoTile, buckets.aggHistogram, buckets.aggDateHistogram, buckets.aggTerms, buckets.aggTimeSeries, buckets.aggMultiTerms, buckets.aggRareTerms, buckets.aggSampler, buckets.aggDiversifiedSampler, metrics.aggAvg, metrics.aggBucketAvg, metrics.aggBucketMax, metrics.aggBucketMin, metrics.aggBucketSum, metrics.aggFilteredMetric, metrics.aggCardinality, metrics.aggValueCount, metrics.aggCount, metrics.aggCumulativeSum, metrics.aggDerivative, metrics.aggGeoBounds, metrics.aggGeoCentroid, metrics.aggMax, metrics.aggMedian, metrics.aggSinglePercentile, metrics.aggSinglePercentileRank, metrics.aggMin, metrics.aggMovingAvg, metrics.aggPercentileRanks, metrics.aggPercentiles, metrics.aggRate, metrics.aggSerialDiff, metrics.aggStdDeviation, metrics.aggSum, metrics.aggTopHit, metrics.aggTopMetrics];
exports.getAggTypesFunctions = getAggTypesFunctions;