"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.versionSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const versionSchema = exports.versionSchema = _configSchema.schema.object({
  runs: _configSchema.schema.number(),
  telemetry: _configSchema.schema.object({
    panels: _configSchema.schema.object({
      total: _configSchema.schema.number(),
      by_reference: _configSchema.schema.number(),
      by_value: _configSchema.schema.number(),
      by_type: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
        total: _configSchema.schema.number(),
        by_reference: _configSchema.schema.number(),
        by_value: _configSchema.schema.number(),
        details: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number())
      }))
    }),
    controls: _configSchema.schema.object({
      total: _configSchema.schema.number(),
      chaining_system: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
      label_position: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
      ignore_settings: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
      by_type: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
        total: _configSchema.schema.number(),
        details: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number())
      }))
    }),
    sections: _configSchema.schema.object({
      total: _configSchema.schema.number()
    })
  })
});