"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardsByIdsAction = void 0;
var _dashboard_client = require("./dashboard_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDashboardsByIdsAction = exports.getDashboardsByIdsAction = {
  id: 'getDashboardsByIdsAction',
  execute: async context => {
    const dashboards = await Promise.all(context.ids.map(async id => {
      try {
        return await _dashboard_client.dashboardClient.get(id);
      } catch {
        return null;
      }
    }));
    context.onResults(dashboards.filter(dashboard => dashboard !== null).map(({
      id,
      data,
      meta
    }) => {
      var _data$title;
      return {
        id,
        isManaged: Boolean(meta.managed),
        title: (_data$title = data.title) !== null && _data$title !== void 0 ? _data$title : ''
      };
    }));
  }
};