"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveDashboard = void 0;
var _i18n = require("@kbn/i18n");
var _dashboard_backup_service = require("../../services/dashboard_backup_service");
var _kibana_services = require("../../services/kibana_services");
var _dashboard_client = require("../../dashboard_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const saveDashboard = async ({
  lastSavedId,
  saveOptions,
  dashboardState,
  references,
  accessMode
}) => {
  const idToSaveTo = saveOptions.saveAsCopy ? undefined : lastSavedId;
  try {
    const result = idToSaveTo ? await _dashboard_client.dashboardClient.update(idToSaveTo, dashboardState, references) : await _dashboard_client.dashboardClient.create(dashboardState, references, accessMode);
    const newId = result.id;
    if (newId) {
      _kibana_services.coreServices.notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('dashboard.dashboardWasSavedSuccessMessage', {
          defaultMessage: `Dashboard ''{title}'' was saved`,
          values: {
            title: dashboardState.title
          }
        }),
        className: 'eui-textBreakWord',
        'data-test-subj': 'saveDashboardSuccess'
      });

      /**
       * If the dashboard id has been changed, redirect to the new ID to keep the url param in sync.
       */
      if (newId !== lastSavedId) {
        (0, _dashboard_backup_service.getDashboardBackupService)().clearState(lastSavedId);
        return {
          redirectRequired: true,
          id: newId,
          references
        };
      }
    }
    return {
      id: newId,
      references
    };
  } catch (error) {
    _kibana_services.coreServices.notifications.toasts.addDanger({
      title: _i18n.i18n.translate('dashboard.dashboardWasNotSavedDangerMessage', {
        defaultMessage: `Dashboard ''{title}'' was not saved. Error: {errorMessage}`,
        values: {
          title: dashboardState.title,
          errorMessage: error.message
        }
      }),
      'data-test-subj': 'saveDashboardFailure'
    });
    return {
      error
    };
  }
};
exports.saveDashboard = saveDashboard;