"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openSaveModal = openSaveModal;
var _react = _interopRequireDefault(require("react"));
var _ebtTools = require("@kbn/ebt-tools");
var _public = require("@kbn/saved-objects-plugin/public");
var _i18n = require("@kbn/i18n");
var _kibana_services = require("../../services/kibana_services");
var _telemetry_constants = require("../../utils/telemetry_constants");
var _extract_title_and_count = require("../../utils/extract_title_and_count");
var _save_modal = require("./save_modal");
var _dashboard_client = require("../../dashboard_client");
var _save_dashboard = require("./save_dashboard");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_api/save_modal/open_save_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * @description exclusively for user directed dashboard save actions, also
 * accounts for scenarios of cloning elastic managed dashboard into user managed dashboards
 */
async function openSaveModal({
  description,
  isManaged,
  lastSavedId,
  serializeState,
  setTimeRestore,
  setProjectRoutingRestore,
  tags,
  timeRestore,
  projectRoutingRestore,
  title,
  viewMode,
  accessControl
}) {
  try {
    if (viewMode === 'edit' && isManaged) {
      return undefined;
    }
    const saveAsTitle = lastSavedId ? await getSaveAsTitle(title) : title;
    return new Promise(resolve => {
      const onSaveAttempt = async ({
        newTags,
        newTitle,
        newDescription,
        newCopyOnSave,
        newTimeRestore,
        newAccessMode,
        newProjectRoutingRestore,
        onTitleDuplicate,
        isTitleDuplicateConfirmed
      }) => {
        const saveOptions = {
          confirmOverwrite: false,
          isTitleDuplicateConfirmed,
          onTitleDuplicate,
          saveAsCopy: lastSavedId ? true : newCopyOnSave
        };
        try {
          if (!(await (0, _dashboard_client.checkForDuplicateDashboardTitle)({
            title: newTitle,
            onTitleDuplicate,
            lastSavedTitle: title,
            copyOnSave: saveOptions.saveAsCopy,
            isTitleDuplicateConfirmed
          }))) {
            return {};
          }
          setTimeRestore(newTimeRestore);
          setProjectRoutingRestore(newProjectRoutingRestore);
          const {
            dashboardState,
            references
          } = serializeState();
          const dashboardStateToSave = {
            ...dashboardState,
            title: newTitle,
            tags: _kibana_services.savedObjectsTaggingService && newTags ? newTags : [],
            description: newDescription
          };

          // TODO If this is a managed dashboard - unlink all by reference embeddables on clone
          // https://github.com/elastic/kibana/issues/190138

          const beforeAddTime = window.performance.now();
          const saveResult = await (0, _save_dashboard.saveDashboard)({
            references,
            saveOptions,
            dashboardState: dashboardStateToSave,
            lastSavedId,
            // Only pass access mode for new dashboard creation (no lastSavedId)
            accessMode: !lastSavedId && newAccessMode ? newAccessMode : undefined
          });
          const addDuration = window.performance.now() - beforeAddTime;
          (0, _ebtTools.reportPerformanceMetricEvent)(_kibana_services.coreServices.analytics, {
            eventName: _telemetry_constants.SAVED_OBJECT_POST_TIME,
            duration: addDuration,
            meta: {
              saved_object_type: _constants.DASHBOARD_SAVED_OBJECT_TYPE
            }
          });
          resolve({
            ...saveResult,
            savedState: dashboardStateToSave
          });
          return saveResult;
        } catch (error) {
          _kibana_services.coreServices.notifications.toasts.addDanger(generateDashboardNotSavedToast(title, error.message));
          return error;
        }
      };
      (0, _public.showSaveModal)(/*#__PURE__*/_react.default.createElement(_save_modal.DashboardSaveModal, {
        tags: tags,
        title: saveAsTitle,
        onClose: () => resolve(undefined),
        timeRestore: timeRestore,
        projectRoutingRestore: projectRoutingRestore,
        showStoreTimeOnSave: !lastSavedId,
        showStoreProjectRoutingOnSave: !lastSavedId && Boolean(_kibana_services.cpsService === null || _kibana_services.cpsService === void 0 ? void 0 : _kibana_services.cpsService.cpsManager),
        description: description !== null && description !== void 0 ? description : '',
        showCopyOnSave: false,
        onSave: onSaveAttempt,
        accessControl: accessControl,
        customModalTitle: getCustomModalTitle(viewMode),
        isDuplicateAction: Boolean(lastSavedId),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 11
        }
      }));
    });
  } catch (error) {
    _kibana_services.coreServices.notifications.toasts.addDanger(generateDashboardNotSavedToast(title, error.message));
    return undefined;
  }
}
function getCustomModalTitle(viewMode) {
  if (viewMode === 'edit') return _i18n.i18n.translate('dashboard.topNav.editModeInteractiveSave.modalTitle', {
    defaultMessage: 'Save as new dashboard'
  });
  if (viewMode === 'view') return _i18n.i18n.translate('dashboard.topNav.viewModeInteractiveSave.modalTitle', {
    defaultMessage: 'Duplicate dashboard'
  });
  return undefined;
}
function generateDashboardNotSavedToast(title, errorMessage) {
  return {
    title: _i18n.i18n.translate('dashboard.dashboardWasNotSavedDangerMessage', {
      defaultMessage: `Dashboard ''{title}'' was not saved. Error: {errorMessage}`,
      values: {
        title,
        errorMessage
      }
    }),
    'data-test-subj': 'saveDashboardFailure'
  };
}
async function getSaveAsTitle(title) {
  const [baseTitle, baseCount] = (0, _extract_title_and_count.extractTitleAndCount)(title);
  let saveAsTitle = `${baseTitle} (${baseCount + 1})`;
  await (0, _dashboard_client.checkForDuplicateDashboardTitle)({
    title: saveAsTitle,
    lastSavedTitle: title,
    copyOnSave: true,
    isTitleDuplicateConfirmed: false,
    onTitleDuplicate(speculativeSuggestion) {
      saveAsTitle = speculativeSuggestion;
    }
  });
  return saveAsTitle;
}