"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserAccessControlData = void 0;
var _constants = require("../../../common/constants");
var _access_control_service = require("../../services/access_control_service");
var _kibana_services = require("../../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getUserAccessControlData = async () => {
  try {
    const accessControlClient = (0, _access_control_service.getAccessControlClient)();
    const currentUser = await (_kibana_services.coreServices === null || _kibana_services.coreServices === void 0 ? void 0 : _kibana_services.coreServices.userProfile.getCurrent());
    const {
      isGloballyAuthorized
    } = await accessControlClient.checkGlobalPrivilege(_constants.DASHBOARD_SAVED_OBJECT_TYPE);
    if (!currentUser) {
      return;
    }
    return {
      uid: currentUser.uid,
      hasGlobalAccessControlPrivilege: isGloballyAuthorized
    };
  } catch (error) {
    return;
  }
};
exports.getUserAccessControlData = getUserAccessControlData;