"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardApi = getDashboardApi;
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _controlsConstants = require("@kbn/controls-constants");
var _page_bundle_constants = require("../../common/page_bundle_constants");
var _common = require("../../common");
var _control_group_manager = require("./control_group_manager");
var _access_control_manager = require("./access_control_manager");
var _data_loading_manager = require("./data_loading_manager");
var _data_views_manager = require("./data_views_manager");
var _default_dashboard_state = require("./default_dashboard_state");
var _layout_manager = require("./layout_manager");
var _open_save_modal = require("./save_modal/open_save_modal");
var _search_session_manager = require("./search_sessions/search_session_manager");
var _settings_manager = require("./settings_manager");
var _track_contentful_render = require("./track_contentful_render");
var _track_overlay = require("./track_overlay");
var _track_panel = require("./track_panel");
var _types = require("./types");
var _unified_search_manager = require("./unified_search_manager");
var _project_routing_manager = require("./project_routing_manager");
var _unsaved_changes_manager = require("./unsaved_changes_manager");
var _view_mode_manager = require("./view_mode_manager");
var _merge_control_group_states = require("./merge_control_group_states");
var _save_dashboard = require("./save_modal/save_dashboard");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getDashboardApi({
  creationOptions,
  incomingEmbeddables,
  initialState,
  readResult,
  savedObjectId,
  user,
  isAccessControlEnabled
}) {
  var _creationOptions$full, _readResult$meta$mana, _readResult$data, _readResult$data$acce, _readResult$data2, _readResult$data2$acc, _readResult$meta, _readResult$meta2;
  const fullScreenMode$ = new _rxjs.BehaviorSubject((_creationOptions$full = creationOptions === null || creationOptions === void 0 ? void 0 : creationOptions.fullScreenMode) !== null && _creationOptions$full !== void 0 ? _creationOptions$full : false);
  const isManaged = (_readResult$meta$mana = readResult === null || readResult === void 0 ? void 0 : readResult.meta.managed) !== null && _readResult$meta$mana !== void 0 ? _readResult$meta$mana : false;
  const savedObjectId$ = new _rxjs.BehaviorSubject(savedObjectId);
  const dashboardContainerRef$ = new _rxjs.BehaviorSubject(null);
  const accessControlManager = (0, _access_control_manager.initializeAccessControlManager)(readResult, savedObjectId$);
  const viewModeManager = (0, _view_mode_manager.initializeViewModeManager)({
    incomingEmbeddables,
    isManaged,
    savedObjectId,
    accessControl: {
      accessMode: readResult === null || readResult === void 0 ? void 0 : (_readResult$data = readResult.data) === null || _readResult$data === void 0 ? void 0 : (_readResult$data$acce = _readResult$data.access_control) === null || _readResult$data$acce === void 0 ? void 0 : _readResult$data$acce.access_mode,
      owner: readResult === null || readResult === void 0 ? void 0 : (_readResult$data2 = readResult.data) === null || _readResult$data2 === void 0 ? void 0 : (_readResult$data2$acc = _readResult$data2.access_control) === null || _readResult$data2$acc === void 0 ? void 0 : _readResult$data2$acc.owner
    },
    createdBy: readResult === null || readResult === void 0 ? void 0 : (_readResult$meta = readResult.meta) === null || _readResult$meta === void 0 ? void 0 : _readResult$meta.created_by,
    user
  });
  const trackPanel = (0, _track_panel.initializeTrackPanel)(async id => {
    await layoutManager.api.getChildApi(id);
  }, dashboardContainerRef$);
  const references$ = new _rxjs.BehaviorSubject(initialState.references);
  const getReferences = id => {
    var _references$$value2;
    if (id === _control_group_manager.CONTROL_GROUP_EMBEDDABLE_ID) {
      var _references$$value;
      return (0, _common.getReferencesForControls)((_references$$value = references$.value) !== null && _references$$value !== void 0 ? _references$$value : []);
    }
    return (0, _common.getReferencesForPanelId)(id, (_references$$value2 = references$.value) !== null && _references$$value2 !== void 0 ? _references$$value2 : []);
  };
  const incomingControlGroup = incomingEmbeddables === null || incomingEmbeddables === void 0 ? void 0 : incomingEmbeddables.find(embeddable => embeddable.type === _controlsConstants.CONTROLS_GROUP_TYPE);
  const restEmbeddables = incomingEmbeddables === null || incomingEmbeddables === void 0 ? void 0 : incomingEmbeddables.filter(embeddable => embeddable.type !== _controlsConstants.CONTROLS_GROUP_TYPE);
  const layoutManager = (0, _layout_manager.initializeLayoutManager)(restEmbeddables, initialState.panels, trackPanel, getReferences);
  const mergedControlGroupState = (0, _merge_control_group_states.mergeControlGroupStates)(initialState.controlGroupInput, incomingControlGroup);
  const controlGroupManager = (0, _control_group_manager.initializeControlGroupManager)(mergedControlGroupState, getReferences, viewModeManager.api.viewMode$.value);
  const dataLoadingManager = (0, _data_loading_manager.initializeDataLoadingManager)(layoutManager.api.children$);
  const dataViewsManager = (0, _data_views_manager.initializeDataViewsManager)(controlGroupManager.api.controlGroupApi$, layoutManager.api.children$);
  const settingsManager = (0, _settings_manager.initializeSettingsManager)(initialState);
  const unifiedSearchManager = (0, _unified_search_manager.initializeUnifiedSearchManager)(initialState, controlGroupManager.api.controlGroupApi$, settingsManager.api.timeRestore$, dataLoadingManager.internalApi.waitForPanelsToLoad$, () => unsavedChangesManager.internalApi.getLastSavedState(), creationOptions);
  const projectRoutingManager = (0, _project_routing_manager.initializeProjectRoutingManager)(initialState, settingsManager.api.projectRoutingRestore$);
  const unsavedChangesManager = (0, _unsaved_changes_manager.initializeUnsavedChangesManager)({
    viewMode$: viewModeManager.api.viewMode$,
    storeUnsavedChanges: creationOptions === null || creationOptions === void 0 ? void 0 : creationOptions.useSessionStorageIntegration,
    controlGroupManager,
    lastSavedState: (0, _default_dashboard_state.getLastSavedState)(readResult),
    layoutManager,
    savedObjectId$,
    settingsManager,
    unifiedSearchManager,
    projectRoutingManager,
    getReferences
  });
  function getState() {
    const {
      panels,
      references: panelReferences
    } = layoutManager.internalApi.serializeLayout();
    const unifiedSearchState = unifiedSearchManager.internalApi.getState();
    const projectRoutingState = projectRoutingManager === null || projectRoutingManager === void 0 ? void 0 : projectRoutingManager.internalApi.getState();
    const dashboardState = {
      ...settingsManager.internalApi.serializeSettings(),
      ...unifiedSearchState,
      ...projectRoutingState,
      panels
    };
    const {
      controlGroupInput,
      controlGroupReferences
    } = controlGroupManager.internalApi.serializeControlGroup();
    dashboardState.controlGroupInput = controlGroupInput;
    return {
      dashboardState,
      references: [...(controlGroupReferences !== null && controlGroupReferences !== void 0 ? controlGroupReferences : []), ...(panelReferences !== null && panelReferences !== void 0 ? panelReferences : [])]
    };
  }
  const trackOverlayApi = (0, _track_overlay.initializeTrackOverlay)(trackPanel.setFocusedPanelId);
  const dashboardApi = {
    ...viewModeManager.api,
    ...dataLoadingManager.api,
    ...dataViewsManager.api,
    ...layoutManager.api,
    ...settingsManager.api,
    ...trackPanel,
    ...unifiedSearchManager.api,
    ...unsavedChangesManager.api,
    ...(projectRoutingManager === null || projectRoutingManager === void 0 ? void 0 : projectRoutingManager.api),
    ...trackOverlayApi,
    ...(0, _track_contentful_render.initializeTrackContentfulRender)(),
    ...controlGroupManager.api,
    executionContext: {
      type: 'dashboard',
      description: settingsManager.api.title$.value
    },
    fullScreenMode$,
    getAppContext: () => {
      var _creationOptions$getE, _embeddableAppContext;
      const embeddableAppContext = creationOptions === null || creationOptions === void 0 ? void 0 : (_creationOptions$getE = creationOptions.getEmbeddableAppContext) === null || _creationOptions$getE === void 0 ? void 0 : _creationOptions$getE.call(creationOptions, savedObjectId$.value);
      return {
        ...embeddableAppContext,
        currentAppId: (_embeddableAppContext = embeddableAppContext === null || embeddableAppContext === void 0 ? void 0 : embeddableAppContext.currentAppId) !== null && _embeddableAppContext !== void 0 ? _embeddableAppContext : _page_bundle_constants.DASHBOARD_APP_ID
      };
    },
    isEmbeddedExternally: Boolean(creationOptions === null || creationOptions === void 0 ? void 0 : creationOptions.isEmbeddedExternally),
    isManaged,
    getSerializedState: () => {
      const {
        dashboardState,
        references
      } = getState();
      return {
        attributes: dashboardState,
        references
      };
    },
    runInteractiveSave: async () => {
      trackOverlayApi.clearOverlays();
      const {
        description,
        tags,
        time_restore: timeRestore,
        project_routing_restore: projectRoutingRestore,
        title
      } = settingsManager.api.getSettings();
      const saveResult = await (0, _open_save_modal.openSaveModal)({
        description,
        isManaged,
        lastSavedId: savedObjectId$.value,
        serializeState: getState,
        setTimeRestore: newTimeRestore => settingsManager.api.setSettings({
          time_restore: newTimeRestore
        }),
        setProjectRoutingRestore: newProjectRoutingRestore => settingsManager.api.setSettings({
          project_routing_restore: newProjectRoutingRestore
        }),
        tags,
        timeRestore,
        projectRoutingRestore,
        title,
        viewMode: viewModeManager.api.viewMode$.value,
        accessControl: accessControlManager.api.accessControl$.value
      });
      if (!saveResult || saveResult.error) {
        return;
      }
      if (saveResult) {
        var _settings$hide_panel_;
        references$.next(saveResult.references);
        unsavedChangesManager.internalApi.onSave(saveResult.savedState);
        const settings = settingsManager.api.getSettings();
        settingsManager.api.setSettings({
          ...settings,
          hide_panel_titles: (_settings$hide_panel_ = settings.hide_panel_titles) !== null && _settings$hide_panel_ !== void 0 ? _settings$hide_panel_ : false,
          description: saveResult.savedState.description,
          tags: saveResult.savedState.tags,
          title: saveResult.savedState.title
        });
        savedObjectId$.next(saveResult.id);
      }
      return saveResult;
    },
    runQuickSave: async () => {
      var _accessControlManager;
      if (isManaged) return;
      const {
        dashboardState,
        references
      } = getState();
      const saveResult = await (0, _save_dashboard.saveDashboard)({
        dashboardState,
        references,
        saveOptions: {},
        lastSavedId: savedObjectId$.value,
        accessMode: (_accessControlManager = accessControlManager.api.accessControl$.value) === null || _accessControlManager === void 0 ? void 0 : _accessControlManager.accessMode
      });
      if (saveResult !== null && saveResult !== void 0 && saveResult.error) return;
      references$.next(saveResult.references);
      unsavedChangesManager.internalApi.onSave(dashboardState);
      return;
    },
    savedObjectId$,
    setFullScreenMode: fullScreenMode => fullScreenMode$.next(fullScreenMode),
    getSerializedStateForChild: childId => {
      return childId === _control_group_manager.CONTROL_GROUP_EMBEDDABLE_ID ? controlGroupManager.internalApi.getStateForControlGroup() : layoutManager.internalApi.getSerializedStateForPanel(childId);
    },
    setSavedObjectId: id => savedObjectId$.next(id),
    type: _types.DASHBOARD_API_TYPE,
    uuid: (0, _uuid.v4)(),
    getPassThroughContext: () => {
      var _creationOptions$getP;
      return creationOptions === null || creationOptions === void 0 ? void 0 : (_creationOptions$getP = creationOptions.getPassThroughContext) === null || _creationOptions$getP === void 0 ? void 0 : _creationOptions$getP.call(creationOptions);
    },
    createdBy: readResult === null || readResult === void 0 ? void 0 : (_readResult$meta2 = readResult.meta) === null || _readResult$meta2 === void 0 ? void 0 : _readResult$meta2.created_by,
    user,
    // TODO: accessControl$ and changeAccessMode should be moved to internalApi
    accessControl$: accessControlManager.api.accessControl$,
    changeAccessMode: accessControlManager.api.changeAccessMode,
    isAccessControlEnabled: Boolean(isAccessControlEnabled)
  };
  const internalApi = {
    ...layoutManager.internalApi,
    ...unifiedSearchManager.internalApi,
    setControlGroupApi: controlGroupManager.internalApi.setControlGroupApi,
    dashboardContainerRef$,
    setDashboardContainerRef: ref => dashboardContainerRef$.next(ref),
    serializeControls: () => controlGroupManager.internalApi.serializeControlGroup()
  };
  const searchSessionManager = (0, _search_session_manager.initializeSearchSessionManager)(creationOptions === null || creationOptions === void 0 ? void 0 : creationOptions.searchSessionSettings, incomingEmbeddables, dashboardApi, internalApi);
  return {
    api: {
      ...dashboardApi,
      ...searchSessionManager.api
    },
    internalApi,
    cleanup: () => {
      dataLoadingManager.cleanup();
      dataViewsManager.cleanup();
      searchSessionManager.cleanup();
      unifiedSearchManager.cleanup();
      unsavedChangesManager.cleanup();
      layoutManager.cleanup();
      projectRoutingManager === null || projectRoutingManager === void 0 ? void 0 : projectRoutingManager.cleanup();
    }
  };
}