"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SMALL_PANEL_WIDTH = exports.SMALL_CHART_TYPES = exports.MARKDOWN_PANEL_WIDTH = exports.MARKDOWN_MIN_HEIGHT = exports.MARKDOWN_MAX_HEIGHT = exports.LARGE_PANEL_WIDTH = exports.DEFAULT_PANEL_HEIGHT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Default panel sizes based on visualization type
const DEFAULT_PANEL_HEIGHT = exports.DEFAULT_PANEL_HEIGHT = 9;
const SMALL_PANEL_WIDTH = exports.SMALL_PANEL_WIDTH = 12; // Metrics & small charts (4 per row)
const LARGE_PANEL_WIDTH = exports.LARGE_PANEL_WIDTH = 24; // XY & other charts (2 per row)

// Markdown panel dimensions
const MARKDOWN_PANEL_WIDTH = exports.MARKDOWN_PANEL_WIDTH = 48; // Full width
const MARKDOWN_MIN_HEIGHT = exports.MARKDOWN_MIN_HEIGHT = 6;
const MARKDOWN_MAX_HEIGHT = exports.MARKDOWN_MAX_HEIGHT = 9;

// Chart types that use smaller panel widths
const SMALL_CHART_TYPES = exports.SMALL_CHART_TYPES = new Set(['metric', 'legacy_metric', 'gauge']);