"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getThemeSettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _coreUiSettingsCommon = require("@kbn/core-ui-settings-common");
var _ui_settings_config = require("../ui_settings_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getThemeInfo = ({
  isDist
}) => {
  const themeTags = (0, _coreUiSettingsCommon.parseThemeTags)(process.env.KBN_OPTIMIZER_THEMES);
  const themeInfo = {
    defaultDarkMode: false
  };
  if (!isDist) {
    var _themeTags$;
    // Allow environment-specific config when not building for distribution
    themeInfo.defaultDarkMode = ((_themeTags$ = themeTags[0]) === null || _themeTags$ === void 0 ? void 0 : _themeTags$.endsWith('dark')) || false;
  }
  return themeInfo;
};
const getThemeSettings = options => {
  var _options$defaultTheme;
  const {
    defaultDarkMode
  } = getThemeInfo(options);
  const defaultTheme = (_options$defaultTheme = options.defaultTheme) !== null && _options$defaultTheme !== void 0 ? _options$defaultTheme : _coreUiSettingsCommon.DEFAULT_THEME_NAME;
  return {
    'theme:darkMode': {
      name: _i18n.i18n.translate('core.ui_settings.params.darkModeTitle', {
        defaultMessage: 'Dark mode'
      }),
      value: defaultDarkMode ? 'enabled' : 'disabled',
      description: _i18n.i18n.translate('core.ui_settings.params.darkModeText', {
        defaultMessage: `The UI theme that the Kibana UI should use. ` + `Set to 'Enabled' to enable the dark theme, or 'Disabled' to disable it. ` + `Set to 'Sync with system' to have the Kibana UI theme follow the system theme. ` + `A page reload is required for the setting to be applied.`
      }),
      type: 'select',
      options: ['enabled', 'disabled', 'system'],
      optionLabels: {
        enabled: _i18n.i18n.translate('core.ui_settings.params.darkMode.options.enabled', {
          defaultMessage: `Enabled`
        }),
        disabled: _i18n.i18n.translate('core.ui_settings.params.darkMode.options.disabled', {
          defaultMessage: `Disabled`
        }),
        system: _i18n.i18n.translate('core.ui_settings.params.darkMode.options.system', {
          defaultMessage: `Sync with system`
        })
      },
      deprecation: {
        message: _i18n.i18n.translate('core.ui_settings.params.darkModeDeprecation', {
          defaultMessage: 'This setting is deprecated and will be removed in Kibana 10.0.'
        }),
        docLinksKey: 'generalSettings'
      },
      requiresPageReload: true,
      schema: _configSchema.schema.oneOf([_configSchema.schema.literal('enabled'), _configSchema.schema.literal('disabled'), _configSchema.schema.literal('system'),
      // for backward-compatibility
      _configSchema.schema.boolean()])
    },
    /**
     * Theme is sticking around as there are still a number of places reading it and
     * we might use it again in the future.
     */
    'theme:version': {
      name: _i18n.i18n.translate('core.ui_settings.params.themeVersionTitle', {
        defaultMessage: 'Theme version'
      }),
      value: 'v8',
      readonly: true,
      schema: _configSchema.schema.literal('v8')
    },
    /**
     * Theme name is the (upcoming) replacement for theme versions.
     */
    'theme:name': {
      name: _i18n.i18n.translate('core.ui_settings.params.themeName', {
        defaultMessage: 'Theme'
      }),
      type: 'select',
      // Cast to a mutable array to satisfy the `UiSettingsParams.options` type
      options: _coreUiSettingsCommon.SUPPORTED_THEME_NAMES,
      optionLabels: {
        borealis: _i18n.i18n.translate('core.ui_settings.params.themeName.options.borealis', {
          defaultMessage: 'Borealis'
        })
      },
      value: defaultTheme,
      readonly: !options.isThemeSwitcherEnabled,
      requiresPageReload: true,
      schema: _ui_settings_config.defaultThemeSchema
    }
  };
};
exports.getThemeSettings = getThemeSettings;