"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnStart = exports.OnSetup = void 0;
exports.PluginSetup = PluginSetup;
exports.PluginStart = PluginStart;
exports.Start = exports.Setup = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Plugin's setup contract.
 * @public
 */
const Setup = exports.Setup = Symbol.for('Setup');

/**
 * Plugin's start contract.
 * @public
 */
const Start = exports.Start = Symbol.for('Start');

/**
 * Plugin's setup lifecycle hook.
 * @public
 */
const OnSetup = exports.OnSetup = Symbol.for('OnSetup');

/**
 * Plugin's start lifecycle hook.
 * @public
 */
const OnStart = exports.OnStart = Symbol.for('OnStart');

/**
 * Plugin's setup dependency.
 * @param plugin The dependency plugin name.
 * @public
 */
function PluginSetup(plugin) {
  return Symbol.for(`plugin.setup.${String(plugin)}`);
}

/**
 * Plugin's start dependency.
 * @param plugin The dependency plugin name.
 * @public
 */
function PluginStart(plugin) {
  return Symbol.for(`plugin.start.${String(plugin)}`);
}