"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStableMenuItemsReference = void 0;
var _react = require("react");
var _have_same_height_signature = require("../utils/have_same_height_signature");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Get a stable reference to the items array that changes only when we need to recalculate the height.
 *
 * @param items - menu items.
 * @returns the stable items reference.
 */
const useStableMenuItemsReference = items => {
  const ref = (0, _react.useRef)(items);
  const out = (0, _have_same_height_signature.haveSameHeightSignature)(ref.current, items) ? ref.current : items;

  // Don’t write to a ref during render
  (0, _react.useLayoutEffect)(() => {
    if (!(0, _have_same_height_signature.haveSameHeightSignature)(ref.current, items)) {
      ref.current = items;
    }
  }, [items]);
  return out;
};
exports.useStableMenuItemsReference = useStableMenuItemsReference;