"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreventLinkNavigation = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Hook for preventing the default navigation behavior of a link.
 * Used in Jest tests and Storybook.
 */
const usePreventLinkNavigation = () => {
  (0, _react.useEffect)(() => {
    const handleClick = e => {
      const anchor = e.target.closest('a');
      if (anchor !== null && anchor !== void 0 && anchor.getAttribute('href')) {
        e.preventDefault();
      }
    };
    document.addEventListener('click', handleClick, true);
    return () => document.removeEventListener('click', handleClick, true);
  }, []);
};
exports.usePreventLinkNavigation = usePreventLinkNavigation;