"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDelayFn = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * HOC wrapping the function with a delay.
 */
const createDelayFn = state => fn => {
  return () => {
    return state.retryDelay > 0 ?
    // we need to use the standard setTimeout here, this way we can alter its behavior with jest.useFakeTimers()
    new Promise(resolve => setTimeout(resolve, state.retryDelay)).then(fn) : fn();
  };
};
exports.createDelayFn = createDelayFn;