"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listFilesOlderThan = exports.listFilesExceedingSize = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _fs = require("./fs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const listFilesExceedingSize = async ({
  orderedFiles,
  maxSizeInBytes
}) => {
  let currentSize = 0;
  for (let i = 0; i < orderedFiles.length; i++) {
    const filePath = orderedFiles[i];
    const stats = await (0, _fs.getFileInfo)(filePath);
    if (stats.exist) {
      currentSize += stats.size;
      if (currentSize > maxSizeInBytes) {
        return orderedFiles.slice(i);
      }
    }
  }
  return [];
};
exports.listFilesExceedingSize = listFilesExceedingSize;
const listFilesOlderThan = async ({
  orderedFiles,
  duration
}) => {
  const filesOlderThanLimit = [];
  const timeLimit = (0, _momentTimezone.default)().subtract(duration).toDate().getTime();
  for (let i = 0; i < orderedFiles.length; i++) {
    const filePath = orderedFiles[i];
    const stats = await (0, _fs.getFileInfo)(filePath);
    if (stats.exist) {
      if (stats.mtime.getTime() < timeLimit) {
        filesOlderThanLimit.push(filePath);
      }
    }
  }
  return filesOlderThanLimit;
};
exports.listFilesOlderThan = listFilesOlderThan;