"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VariableControlsStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const VariableControlsStrings = exports.VariableControlsStrings = {
  displayName: _i18n.i18n.translate('controls.esqlValuesControl.displayName', {
    defaultMessage: 'Static values list'
  }),
  emptySelectionPlaceholder: _i18n.i18n.translate('controls.optionsList.popover.emptySelectionPlaceholder', {
    defaultMessage: 'Select a value'
  }),
  getIncompatibleSelectionsLabel(incompatibleSelectionCount) {
    return _i18n.i18n.translate('controls.optionsList.popover.incompatibleSelectionsSectionTitle', {
      defaultMessage: 'Incompatible {incompatibleSelectionCount, plural, one {selection} other {selections}} ({incompatibleSelectionCount})',
      values: {
        incompatibleSelectionCount
      }
    });
  }
};