"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startAccessControlSync = exports.StartAccessControlSyncApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const startAccessControlSync = async ({
  connectorId,
  http
}) => {
  const route = `/internal/content_connectors/connectors/${connectorId}/start_access_control_sync`;
  return await (http === null || http === void 0 ? void 0 : http.post(route));
};
exports.startAccessControlSync = startAccessControlSync;
const StartAccessControlSyncApiLogic = exports.StartAccessControlSyncApiLogic = (0, _create_api_logic.createApiLogic)(['start_access_control_sync_api_logic'], startAccessControlSync, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.index.accessControlSyncSuccess.message', {
    defaultMessage: 'Successfully scheduled an access control sync, waiting for a connector to pick it up'
  })
});