"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OAuth = void 0;
var _v = require("@kbn/zod/v4");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const authSchema = _v.z.object({
  tokenUrl: _v.z.url().meta({
    label: i18n.OAUTH_TOKEN_URL_LABEL
  }),
  clientId: _v.z.string().min(1, {
    message: i18n.OAUTH_CLIENT_ID_REQUIRED_MESSAGE
  }).meta({
    label: i18n.OAUTH_CLIENT_ID_LABEL
  }),
  scope: _v.z.string().meta({
    label: i18n.OAUTH_SCOPE_LABEL
  }).optional(),
  clientSecret: _v.z.string().min(1, {
    message: i18n.OAUTH_CLIENT_SECRET_REQUIRED_MESSAGE
  }).meta({
    label: i18n.OAUTH_CLIENT_SECRET_LABEL,
    sensitive: true
  })
}).meta({
  label: i18n.OAUTH_LABEL
});
/**
 * OAuth2 Client Credentials Flow
 */
const OAuth = exports.OAuth = {
  id: 'oauth_client_credentials',
  schema: authSchema,
  configure: async (ctx, axiosInstance, secret) => {
    let token;
    try {
      token = await ctx.getToken({
        tokenUrl: secret.tokenUrl,
        scope: secret.scope,
        clientId: secret.clientId,
        clientSecret: secret.clientSecret
      });
    } catch (error) {
      throw new Error(`Unable to retrieve/refresh the access token: ${error.message}`);
    }
    if (!token) {
      throw new Error(`Unable to retrieve new access token`);
    }

    // set global defaults
    axiosInstance.defaults.headers.common.Authorization = token;
    return axiosInstance;
  }
};