"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutorSubActionAddEventParamsSchema = exports.ExecutorParamsSchemaITOM = void 0;
var _zod = require("@kbn/zod");
var _servicenow = require("../../servicenow");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ExecutorSubActionAddEventParamsSchema = exports.ExecutorSubActionAddEventParamsSchema = _zod.z.object({
  source: _zod.z.string().nullable().default(null),
  event_class: _zod.z.string().nullable().default(null),
  resource: _zod.z.string().nullable().default(null),
  node: _zod.z.string().nullable().default(null),
  metric_name: _zod.z.string().nullable().default(null),
  type: _zod.z.string().nullable().default(null),
  severity: _zod.z.string().nullable().default(null),
  description: _zod.z.string().nullable().default(null),
  additional_info: _zod.z.string().nullable().default(null),
  message_key: _zod.z.string().nullable().default(_servicenow.DEFAULT_ALERTS_GROUPING_KEY),
  time_of_event: _zod.z.string().nullable().default(null)
}).strict();
const ExecutorParamsSchemaITOM = exports.ExecutorParamsSchemaITOM = _zod.z.discriminatedUnion('subAction', [_zod.z.object({
  subAction: _zod.z.literal('addEvent'),
  subActionParams: ExecutorSubActionAddEventParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('getChoices'),
  subActionParams: _servicenow.ExecutorSubActionGetChoicesParamsSchema
}).strict()]);