"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestConnectorParamsSchema = exports.RunScriptParamsSchema = exports.ReleaseHostParamsSchema = exports.MicrosoftDefenderEndpointSecretsSchema = exports.MicrosoftDefenderEndpointEmptyParamsSchema = exports.MicrosoftDefenderEndpointDoNotValidateResponseSchema = exports.MicrosoftDefenderEndpointConfigSchema = exports.MicrosoftDefenderEndpointBaseApiResponseSchema = exports.MicrosoftDefenderEndpointActionParamsSchema = exports.MSDefenderLibraryFileSchema = exports.IsolateHostParamsSchema = exports.GetLibraryFilesResponse = exports.GetActionsParamsSchema = exports.GetActionResultsParamsSchema = exports.DownloadActionResultsResponseSchema = exports.CancelParamsSchema = exports.AgentListParamsSchema = exports.AgentDetailsParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// ----------------------------------
// Connector setup schemas
// ----------------------------------
const MicrosoftDefenderEndpointConfigSchema = exports.MicrosoftDefenderEndpointConfigSchema = _zod.z.object({
  clientId: _zod.z.string().min(1),
  tenantId: _zod.z.string().min(1),
  oAuthServerUrl: _zod.z.string().min(1),
  oAuthScope: _zod.z.string().min(1),
  apiUrl: _zod.z.string().min(1)
}).strict();
const MicrosoftDefenderEndpointSecretsSchema = exports.MicrosoftDefenderEndpointSecretsSchema = _zod.z.object({
  clientSecret: _zod.z.string().min(1)
}).strict();

// ----------------------------------
// Connector Methods
// ----------------------------------
const MicrosoftDefenderEndpointDoNotValidateResponseSchema = exports.MicrosoftDefenderEndpointDoNotValidateResponseSchema = _zod.z.any();
const MicrosoftDefenderEndpointBaseApiResponseSchema = exports.MicrosoftDefenderEndpointBaseApiResponseSchema = _zod.z.object({}).passthrough().optional();
const MicrosoftDefenderEndpointEmptyParamsSchema = exports.MicrosoftDefenderEndpointEmptyParamsSchema = _zod.z.object({}).strict();
const TestConnectorParamsSchema = exports.TestConnectorParamsSchema = _zod.z.object({}).strict();
const AgentDetailsParamsSchema = exports.AgentDetailsParamsSchema = _zod.z.object({
  id: _zod.z.string().min(1)
}).strict();
const MachineHealthStatusSchema = _zod.z.enum(['Active', 'Inactive', 'ImpairedCommunication', 'NoSensorData', 'NoSensorDataImpairedCommunication', 'Unknown']);
const AgentListParamsSchema = exports.AgentListParamsSchema = _zod.z.object({
  computerDnsName: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  id: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  version: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  deviceValue: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  aaDeviceId: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  machineTags: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  lastSeen: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  exposureLevel: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  onboardingStatus: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  lastIpAddress: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  healthStatus: _zod.z.union([MachineHealthStatusSchema, _zod.z.array(MachineHealthStatusSchema).min(1)]).optional(),
  osPlatform: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  riskScore: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  rbacGroupId: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  page: _zod.z.coerce.number().min(1).default(1).optional(),
  pageSize: _zod.z.coerce.number().min(1).max(1000).default(20).optional()
}).strict();
const IsolateHostParamsSchema = exports.IsolateHostParamsSchema = _zod.z.object({
  id: _zod.z.string().min(1),
  comment: _zod.z.string().min(1)
}).strict();
const ReleaseHostParamsSchema = exports.ReleaseHostParamsSchema = _zod.z.object({
  id: _zod.z.string().min(1),
  comment: _zod.z.string().min(1)
}).strict();
const RunScriptParamsSchema = exports.RunScriptParamsSchema = _zod.z.object({
  id: _zod.z.string().min(1),
  comment: _zod.z.string().min(1).optional(),
  parameters: _zod.z.object({
    scriptName: _zod.z.string().min(1),
    args: _zod.z.string().min(1).optional()
  }).strict()
}).strict();
const CancelParamsSchema = exports.CancelParamsSchema = _zod.z.object({
  comment: _zod.z.string().min(1),
  actionId: _zod.z.string().min(1)
}).strict();
const MachineActionTypeSchema = _zod.z.enum(['RunAntiVirusScan', 'Offboard', 'LiveResponse', 'CollectInvestigationPackage', 'Isolate', 'Unisolate', 'StopAndQuarantineFile', 'RestrictCodeExecution', 'UnrestrictCodeExecution']);
const MachineActionStatusSchema = _zod.z.enum(['Pending', 'InProgress', 'Succeeded', 'Failed', 'TimeOut', 'Cancelled']);
const GetActionsParamsSchema = exports.GetActionsParamsSchema = _zod.z.object({
  id: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  status: _zod.z.union([MachineActionStatusSchema, _zod.z.array(MachineActionStatusSchema).min(1)]).optional(),
  machineId: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  type: _zod.z.union([MachineActionTypeSchema, _zod.z.array(MachineActionTypeSchema).min(1)]).optional(),
  requestor: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  creationDateTimeUtc: _zod.z.union([_zod.z.string().min(1), _zod.z.array(_zod.z.string().min(1)).min(1)]).optional(),
  page: _zod.z.coerce.number().min(1).default(1).optional(),
  pageSize: _zod.z.coerce.number().min(1).max(1000).default(20).optional(),
  sortField: _zod.z.string().min(1).optional(),
  sortDirection: _zod.z.enum(['asc', 'desc']).optional()
}).strict();
const GetActionResultsParamsSchema = exports.GetActionResultsParamsSchema = _zod.z.object({
  id: _zod.z.string().min(1)
}).strict();
const MSDefenderLibraryFileSchema = exports.MSDefenderLibraryFileSchema = _zod.z.object({
  fileName: _zod.z.string().optional(),
  sha256: _zod.z.string().optional(),
  description: _zod.z.string().optional(),
  creationTime: _zod.z.string().optional(),
  lastUpdatedTime: _zod.z.string().optional(),
  createdBy: _zod.z.string().optional(),
  hasParameters: _zod.z.boolean().optional(),
  parametersDescription: _zod.z.string().nullish()
}).passthrough();
const GetLibraryFilesResponse = exports.GetLibraryFilesResponse = _zod.z.object({
  '@odata.context': _zod.z.string().optional(),
  value: _zod.z.array(MSDefenderLibraryFileSchema).optional()
}).passthrough();
const DownloadActionResultsResponseSchema = exports.DownloadActionResultsResponseSchema = _zod.z.any();

// ----------------------------------
// Connector Sub-Actions
// ----------------------------------

const TestConnectorSchema = _zod.z.object({
  subAction: _zod.z.literal(_constants.SUB_ACTION.TEST_CONNECTOR),
  subActionParams: TestConnectorParamsSchema
}).strict();
const IsolateHostSchema = _zod.z.object({
  subAction: _zod.z.literal(_constants.SUB_ACTION.ISOLATE_HOST),
  subActionParams: IsolateHostParamsSchema
}).strict();
const ReleaseHostSchema = _zod.z.object({
  subAction: _zod.z.literal(_constants.SUB_ACTION.RELEASE_HOST),
  subActionParams: ReleaseHostParamsSchema
}).strict();
const RunScriptSchema = _zod.z.object({
  subAction: _zod.z.literal(_constants.SUB_ACTION.RUN_SCRIPT),
  subActionParams: RunScriptParamsSchema
}).strict();
const MicrosoftDefenderEndpointActionParamsSchema = exports.MicrosoftDefenderEndpointActionParamsSchema = _zod.z.union([TestConnectorSchema, IsolateHostSchema, ReleaseHostSchema, RunScriptSchema]);