"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.D3SecuritySecretsSchema = exports.D3SecurityRunActionResponseSchema = exports.D3SecurityRunActionParamsSchema = exports.D3SecurityConfigSchema = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Connector schema
const D3SecurityConfigSchema = exports.D3SecurityConfigSchema = _zod.z.object({
  url: _zod.z.string()
}).strict();
const D3SecuritySecretsSchema = exports.D3SecuritySecretsSchema = _zod.z.object({
  token: _zod.z.string()
}).strict();

// Run action schema
const D3SecurityRunActionParamsSchema = exports.D3SecurityRunActionParamsSchema = _zod.z.object({
  body: _zod.z.string().optional(),
  severity: _zod.z.string().default(_constants.D3SecuritySeverity.EMPTY).optional(),
  eventType: _zod.z.string().default('').optional()
}).strict();
const D3SecurityRunActionResponseSchema = exports.D3SecurityRunActionResponseSchema = _zod.z.object({
  refid: _zod.z.string()
});