"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEnrichPolicyId = exports.extractErrorMessage = exports.defaultErrorMessage = exports.buildVulnerabilityEntityFlyoutPreviewQuery = exports.buildMutedRulesFilter = exports.buildMisconfigurationEntityFlyoutPreviewQuery = exports.buildGenericEntityFlyoutPreviewQuery = exports.buildEntityAlertsQuery = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultErrorMessage = exports.defaultErrorMessage = _i18n.i18n.translate('securitySolutionPackages.csp.common.utils.helpers.unknownError', {
  defaultMessage: 'Unknown Error'
});
const extractErrorMessage = (e, fallbackMessage) => {
  if (e instanceof Error) return e.message;
  if (typeof e === 'string') return e;
  return fallbackMessage !== null && fallbackMessage !== void 0 ? fallbackMessage : defaultErrorMessage;
};
exports.extractErrorMessage = extractErrorMessage;
const buildMutedRulesFilter = rulesStates => {
  const mutedRules = Object.fromEntries(Object.entries(rulesStates).filter(([key, value]) => value.muted === true));
  const mutedRulesFilterQuery = Object.keys(mutedRules).map(key => {
    const rule = mutedRules[key];
    return {
      bool: {
        must: [{
          term: {
            'rule.benchmark.id': rule.benchmark_id
          }
        }, {
          term: {
            'rule.benchmark.version': rule.benchmark_version
          }
        }, {
          term: {
            'rule.benchmark.rule_number': rule.rule_number
          }
        }]
      }
    };
  });
  return mutedRulesFilterQuery;
};
exports.buildMutedRulesFilter = buildMutedRulesFilter;
const buildGenericEntityFlyoutPreviewQuery = (field, queryValue, status, queryField) => {
  return {
    bool: {
      filter: [{
        bool: {
          should: [{
            term: {
              [field]: `${queryValue || ''}`
            }
          }],
          minimum_should_match: 1
        }
      }, status && queryField ? {
        bool: {
          should: [{
            term: {
              [queryField]: {
                value: status,
                case_insensitive: true
              }
            }
          }],
          minimum_should_match: 1
        }
      } : undefined].filter(Boolean)
    }
  };
};

// Higher-order function for Misconfiguration
exports.buildGenericEntityFlyoutPreviewQuery = buildGenericEntityFlyoutPreviewQuery;
const buildMisconfigurationEntityFlyoutPreviewQuery = (field, queryValue, status) => {
  const queryField = 'result.evaluation';
  return buildGenericEntityFlyoutPreviewQuery(field, queryValue, status, queryField);
};

// Higher-order function for Vulnerability
exports.buildMisconfigurationEntityFlyoutPreviewQuery = buildMisconfigurationEntityFlyoutPreviewQuery;
const buildVulnerabilityEntityFlyoutPreviewQuery = (field, queryValue, status) => {
  const queryField = 'vulnerability.severity';
  return buildGenericEntityFlyoutPreviewQuery(field, queryValue, status, queryField);
};
exports.buildVulnerabilityEntityFlyoutPreviewQuery = buildVulnerabilityEntityFlyoutPreviewQuery;
const buildEntityAlertsQuery = ({
  field,
  to,
  from,
  queryValue = '',
  size = 0,
  severity,
  sortField,
  sortDirection
}) => {
  return {
    size: size || 0,
    _source: false,
    sort: sortField ? [{
      [sortField]: sortDirection
    }] : [],
    fields: ['_id', '_index', 'kibana.alert.rule.uuid', 'kibana.alert.severity', 'kibana.alert.rule.name', 'kibana.alert.workflow_status'],
    query: {
      bool: {
        filter: [{
          bool: {
            should: [{
              term: {
                [field]: `${queryValue || ''}`
              }
            }],
            minimum_should_match: 1
          }
        }, severity ? {
          bool: {
            should: [{
              term: {
                'kibana.alert.severity': severity
              }
            }],
            minimum_should_match: 1
          }
        } : undefined, {
          range: {
            '@timestamp': {
              gte: from,
              lte: to
            }
          }
        }, {
          terms: {
            'kibana.alert.workflow_status': ['open', 'acknowledged']
          }
        }].filter(Boolean)
      }
    },
    // TODO: Asset Inventory - remove temp runtime mappings
    runtime_mappings: {
      'related.entity': {
        type: 'keyword'
      }
    }
  };
};

// Get the enrich policy ID for a specific space
exports.buildEntityAlertsQuery = buildEntityAlertsQuery;
const getEnrichPolicyId = (space = 'default') => {
  return _constants.GENERIC_ENTITY_INDEX_ENRICH_POLICY.replace('<space>', space);
};
exports.getEnrichPolicyId = getEnrichPolicyId;