"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppearanceModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _values_group = require("./values_group");
var _use_appearance_hook = require("./use_appearance_hook");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cloud_integrations/cloud_links/public/maybe_add_cloud_links/appearance_selector/appearance_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const systemLabel = _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalSystemLabel', {
  defaultMessage: 'System'
});
const colorModeOptions = [{
  id: 'system',
  label: systemLabel,
  icon: 'desktop'
}, {
  id: 'light',
  label: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalLightLabel', {
    defaultMessage: 'Light'
  }),
  icon: 'sun'
}, {
  id: 'dark',
  label: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalDarkLabel', {
    defaultMessage: 'Dark'
  }),
  icon: 'moon'
}, {
  id: 'space_default',
  label: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalSpaceDefaultLabel', {
    defaultMessage: 'Space default'
  }),
  icon: 'spaces',
  betaBadgeLabel: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalBetaBadgeLabel', {
    defaultMessage: 'Deprecated'
  }),
  betaBadgeTooltipContent: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalBetaBadgeTooltip', {
    defaultMessage: 'Space default settings will be deprecated in 10.0.'
  }),
  betaBadgeIconType: 'warning'
}];
const ColorModeGroup = ({
  isServerless,
  colorMode,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_values_group.ValuesGroup, {
    title: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalColorModeTitle', {
      defaultMessage: 'Color mode'
    }),
    values: isServerless ? colorModeOptions.filter(({
      id
    }) => id !== 'space_default') : colorModeOptions,
    selectedValue: colorMode,
    onChange: id => {
      onChange({
        colorMode: id
      }, false);
    },
    ariaLabel: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalColorModeAriaLabel', {
      defaultMessage: 'Appearance color mode'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }), colorMode === 'space_default' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: false,
    title: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalDeprecatedSpaceDefaultTitle', {
      defaultMessage: 'Space default settings will be removed in a future version'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalDeprecatedSpaceDefaultDescr', {
    defaultMessage: 'All users with the Space default color mode enabled will be automatically transitioned to the System color mode.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  })));
};
const ContrastModeGroup = ({
  contrastMode,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_values_group.ValuesGroup, {
    title: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalContrastModeTitle', {
      defaultMessage: 'Interface contrast'
    }),
    values: [{
      id: 'system',
      label: systemLabel,
      icon: 'desktop'
    }, {
      id: 'standard',
      label: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalContrastModeStandard', {
        defaultMessage: 'Normal'
      }),
      icon: 'contrast'
    }, {
      id: 'high',
      label: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalContrastModeHigh', {
        defaultMessage: 'High'
      }),
      icon: 'contrastHigh'
    }],
    selectedValue: contrastMode,
    onChange: id => {
      onChange({
        contrastMode: id
      }, false);
    },
    ariaLabel: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalContrastModeAriaLabel', {
      defaultMessage: 'Appearance contrast mode'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  });
};
const AppearanceModal = ({
  closeModal,
  uiSettingsClient,
  isServerless
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    colorMode,
    initialColorModeValue,
    contrastMode,
    initialContrastModeValue,
    isLoading,
    onChange
  } = (0, _use_appearance_hook.useAppearance)({
    uiSettingsClient,
    defaultColorMode: isServerless ? 'system' : 'space_default',
    defaultContrastMode: 'standard'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: closeModal,
    style: isServerless ? undefined :
    // When not in serverless, we have the "Space default" as an option.
    // which renders a warning callout. We don't want the modal to scale up when
    // the callout is rendered, so we set a fixed width.
    {
      width: 580
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    size: "m",
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalTitle', {
    defaultMessage: 'Appearance'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ColorModeGroup, {
    isServerless: isServerless,
    colorMode: colorMode,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(ContrastModeGroup, {
    contrastMode: contrastMode,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "appearanceModalDiscardButton",
    onClick: closeModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalDiscardBtnLabel', {
    defaultMessage: 'Discard'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "appearanceModalSaveButton",
    onClick: async () => {
      if (colorMode !== initialColorModeValue || contrastMode !== initialContrastModeValue) {
        onChange({
          colorMode,
          contrastMode
        }, true);
      }
      closeModal();
    },
    fill: true,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalSaveBtnLabel', {
    defaultMessage: 'Save changes'
  }))));
};
exports.AppearanceModal = AppearanceModal;