"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildClusterQueryParams = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Builds query parameters from cluster configuration for Cloud signup/login links
 */
const buildClusterQueryParams = clusterConfig => {
  var _clusterConfig$cluste, _clusterConfig$cluste2, _clusterConfig$cluste3, _clusterConfig$licens, _clusterConfig$licens2;
  if (!clusterConfig) return '';
  const params = new URLSearchParams();
  if ((_clusterConfig$cluste = clusterConfig.cluster) !== null && _clusterConfig$cluste !== void 0 && _clusterConfig$cluste.id) {
    params.append('cluster_id', clusterConfig.cluster.id);
  }
  if ((_clusterConfig$cluste2 = clusterConfig.cluster) !== null && _clusterConfig$cluste2 !== void 0 && _clusterConfig$cluste2.name) {
    params.append('cluster_name', clusterConfig.cluster.name);
  }
  if ((_clusterConfig$cluste3 = clusterConfig.cluster) !== null && _clusterConfig$cluste3 !== void 0 && _clusterConfig$cluste3.version) {
    params.append('cluster_version', clusterConfig.cluster.version);
  }
  if ((_clusterConfig$licens = clusterConfig.license) !== null && _clusterConfig$licens !== void 0 && _clusterConfig$licens.type) {
    params.append('license_type', clusterConfig.license.type);
  }
  if ((_clusterConfig$licens2 = clusterConfig.license) !== null && _clusterConfig$licens2 !== void 0 && _clusterConfig$licens2.uid) {
    params.append('license_uid', clusterConfig.license.uid);
  }
  return params.toString();
};
exports.buildClusterQueryParams = buildClusterQueryParams;