"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStep3Description = exports.getStep2Description = exports.STEP_3_TITLE = exports.STEP_2_TITLE = exports.STEP_1_TITLE = exports.STEP_1_DESCRIPTION_2 = exports.STEP_1_DESCRIPTION_1 = exports.SIGN_UP_BUTTON = exports.LOGIN_BUTTON = exports.CONNECT_BUTTON = exports.API_KEY_PLACEHOLDER = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cloud_connect/public/application/components/onboarding/connection_wizard/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const STEP_1_TITLE = exports.STEP_1_TITLE = _i18n.i18n.translate('xpack.cloudConnect.wizard.step1.title', {
  defaultMessage: 'Sign up or log in to Elastic Cloud and get the Cloud Connect API key'
});
const STEP_1_DESCRIPTION_1 = exports.STEP_1_DESCRIPTION_1 = _i18n.i18n.translate('xpack.cloudConnect.wizard.step1.description', {
  defaultMessage: 'If you already have an Elastic Cloud account with admin privileges, log in to generate the Cloud Connect API key.'
});
const STEP_1_DESCRIPTION_2 = exports.STEP_1_DESCRIPTION_2 = _i18n.i18n.translate('xpack.cloudConnect.wizard.step1.description', {
  defaultMessage: 'If you don’t have an account yet, sign up and follow the prompts to create your account and start a free trial, and then generate the Cloud Connect API key.'
});
const STEP_2_TITLE = exports.STEP_2_TITLE = _i18n.i18n.translate('xpack.cloudConnect.wizard.step2.title', {
  defaultMessage: 'Configure an encryption key'
});
const getStep2Description = docLinksSecureSavedObject => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.cloudConnect.wizard.step2.description",
  defaultMessage: "Configure an {encryptionKeyLink} in Kibana.",
  values: {
    encryptionKeyLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinksSecureSavedObject,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudConnect.wizard.step2.encryptionKeyLink",
      defaultMessage: "encryption key",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 11
      }
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 3
  }
});
exports.getStep2Description = getStep2Description;
const STEP_3_TITLE = exports.STEP_3_TITLE = _i18n.i18n.translate('xpack.cloudConnect.wizard.step3.title', {
  defaultMessage: 'Paste your Cloud Connect API key and connect'
});
const getStep3Description = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.cloudConnect.wizard.step3.description",
  defaultMessage: "Paste your generated Cloud Connect API key in the following field and click {connect}.",
  values: {
    connect: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudConnect.wizard.step3.descriptionConnectLabel",
      defaultMessage: "Connect",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 3
  }
});
exports.getStep3Description = getStep3Description;
const SIGN_UP_BUTTON = exports.SIGN_UP_BUTTON = _i18n.i18n.translate('xpack.cloudConnect.wizard.signUpButton', {
  defaultMessage: 'Sign up'
});
const LOGIN_BUTTON = exports.LOGIN_BUTTON = _i18n.i18n.translate('xpack.cloudConnect.wizard.loginButton', {
  defaultMessage: 'Log in'
});
const CONNECT_BUTTON = exports.CONNECT_BUTTON = _i18n.i18n.translate('xpack.cloudConnect.wizard.connectButton', {
  defaultMessage: 'Connect'
});
const API_KEY_PLACEHOLDER = exports.API_KEY_PLACEHOLDER = _i18n.i18n.translate('xpack.cloudConnect.wizard.apiKeyPlaceholder', {
  defaultMessage: 'Paste your Cloud Connect API key'
});