"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTemplateFilePath = void 0;
var _path = require("path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTemplateFilePath = (filePath, fileName) => {
  const path = (0, _path.join)(__dirname, '..', 'templates', filePath, fileName);
  const absolutePath = (0, _path.resolve)(path);
  if (!absolutePath) {
    throw new Error('Error finding the file!');
  }
  return absolutePath;
};
exports.getTemplateFilePath = getTemplateFilePath;