"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emptyCasesAssigneesSanitizer = exports.emptyCaseAssigneesSanitizer = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyCaseAssigneesSanitizer = theCase => {
  var _theCase$assignees;
  if ((0, _lodash.isEmpty)(theCase.assignees)) {
    return theCase;
  }
  return {
    ...theCase,
    assignees: (_theCase$assignees = theCase.assignees) === null || _theCase$assignees === void 0 ? void 0 : _theCase$assignees.filter(({
      uid
    }) => !(0, _lodash.isEmpty)(uid))
  };
};
exports.emptyCaseAssigneesSanitizer = emptyCaseAssigneesSanitizer;
const emptyCasesAssigneesSanitizer = ({
  cases
}) => {
  return {
    cases: cases.map(theCase => {
      return emptyCaseAssigneesSanitizer(theCase);
    })
  };
};
exports.emptyCasesAssigneesSanitizer = emptyCasesAssigneesSanitizer;