"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynchronizationTaskRunner = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../constants");
var _synchronization_sub_task = require("./synchronization_sub_task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SynchronizationTaskRunner {
  constructor({
    taskInstance,
    getESClient,
    logger,
    analyticsConfig
  }) {
    (0, _defineProperty2.default)(this, "owner", void 0);
    (0, _defineProperty2.default)(this, "spaceId", void 0);
    (0, _defineProperty2.default)(this, "getESClient", void 0);
    (0, _defineProperty2.default)(this, "previousTaskState", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "analyticsConfig", void 0);
    this.previousTaskState = taskInstance.state || undefined;
    this.owner = taskInstance.params.owner;
    this.spaceId = taskInstance.params.spaceId;
    this.getESClient = getESClient;
    this.logger = logger;
    this.analyticsConfig = analyticsConfig;
  }
  async run() {
    if (!this.analyticsConfig.index.enabled) {
      this.logger.debug(`[synchronization-task-runner] Analytics index is disabled, skipping synchronization task.`, {
        tags: ['cai-synchronization', 'synchronization-task-runner']
      });
      return;
    }
    const esClient = await this.getESClient();
    const subTasks = _constants.CAISyncTypes.map(syncType => {
      const stateForSyncType = this.previousTaskState ? this.previousTaskState[syncType] : undefined;
      return new _synchronization_sub_task.SynchronizationSubTaskRunner({
        esReindexTaskId: stateForSyncType === null || stateForSyncType === void 0 ? void 0 : stateForSyncType.esReindexTaskId,
        lastSyncSuccess: stateForSyncType === null || stateForSyncType === void 0 ? void 0 : stateForSyncType.lastSyncSuccess,
        lastSyncAttempt: stateForSyncType === null || stateForSyncType === void 0 ? void 0 : stateForSyncType.lastSyncAttempt,
        sourceIndex: (0, _constants.sourceIndexBySyncType)(syncType),
        destIndex: (0, _constants.destinationIndexBySyncType)(syncType, this.spaceId, this.owner),
        owner: this.owner,
        spaceId: this.spaceId,
        syncType,
        esClient,
        logger: this.logger
      }).run();
    });

    // We're not catching errors here so that sub task errors are bubbled up and handled by the task manager
    const results = await Promise.all(subTasks);
    const newTaskState = results.reduce((acc, result) => {
      if (result !== null && result !== void 0 && result.syncType) {
        acc[result.syncType] = result;
        return acc;
      }
      return acc;
    }, {});
    return {
      state: {
        ...this.previousTaskState,
        ...newTaskState
      }
    };
  }
  async cancel() {}
}
exports.SynchronizationTaskRunner = SynchronizationTaskRunner;