"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Create = void 0;
var _react = _interopRequireDefault(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _config = require("./config");
var _optional_field_label = require("../../optional_field_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/custom_fields/text/create.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CreateComponent = ({
  customFieldConfiguration,
  isLoading,
  setAsOptional,
  setDefaultValue = true
}) => {
  const {
    key,
    label,
    required,
    defaultValue
  } = customFieldConfiguration;
  const config = (0, _config.getTextFieldConfig)({
    required: setAsOptional ? false : required,
    label,
    ...(defaultValue && setDefaultValue && {
      defaultValue: String(defaultValue)
    })
  });
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `customFields.${key}`,
    config: config,
    component: _components.TextField,
    label: label,
    componentProps: {
      labelAppend: setAsOptional ? _optional_field_label.OptionalFieldLabel : null,
      euiFieldProps: {
        'data-test-subj': `${key}-text-create-custom-field`,
        fullWidth: true,
        disabled: isLoading,
        isLoading
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  });
};
CreateComponent.displayName = 'Create';
const Create = exports.Create = /*#__PURE__*/_react.default.memo(CreateComponent);