"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateSchema = exports.AllCasesURLQueryParamsRt = void 0;
var _Either = require("fp-ts/Either");
var rt = _interopRequireWildcard(require("io-ts"));
var _domain = require("../../../common/types/domain");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AllCasesURLQueryParamsRt = exports.AllCasesURLQueryParamsRt = rt.exact(rt.partial({
  search: rt.string,
  severity: rt.array(_domain.CaseSeverityRt),
  status: rt.array(_domain.CaseStatusRt),
  tags: rt.array(rt.string),
  category: rt.array(rt.string),
  assignees: rt.array(rt.union([rt.string, rt.null])),
  customFields: rt.record(rt.string, rt.array(rt.string)),
  from: rt.string,
  to: rt.string,
  sortOrder: rt.union([rt.literal('asc'), rt.literal('desc')]),
  sortField: rt.union([rt.literal('closedAt'), rt.literal('createdAt'), rt.literal('updatedAt'), rt.literal('severity'), rt.literal('status'), rt.literal('title'), rt.literal('category')]),
  page: rt.number,
  perPage: rt.number
}));
const validateSchema = (obj, schema) => {
  const decoded = schema.decode(obj);
  if ((0, _Either.isLeft)(decoded)) {
    return null;
  } else {
    return decoded.right;
  }
};
exports.validateSchema = validateSchema;