"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _add_canvas_element_trigger = require("../../../state/triggers/add_canvas_element_trigger");
var _use_canvas_api = require("../../hooks/use_canvas_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/editor_menu/editor_menu.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getEditorMenuButtonLabel: () => _i18n.i18n.translate('xpack.canvas.solutionToolbar.editorMenuButtonLabel', {
    defaultMessage: 'Select type'
  })
};
const EditorMenu = ({
  addPanelActions,
  createNewEmbeddableFromAction
}) => {
  const canvasApi = (0, _use_canvas_api.useCanvasApi)();
  const getAddPanelActionMenuItems = (0, _react.useCallback)(closePopover => {
    return addPanelActions.map(item => {
      var _item$getDisplayNameT, _item$order;
      const context = {
        embeddable: canvasApi,
        trigger: _add_canvas_element_trigger.addCanvasElementTrigger
      };
      const actionName = item.getDisplayName(context);
      return {
        name: actionName,
        icon: item.getIconType(context),
        onClick: createNewEmbeddableFromAction(item, context, closePopover),
        'data-test-subj': `create-action-${actionName}`,
        toolTipContent: item === null || item === void 0 ? void 0 : (_item$getDisplayNameT = item.getDisplayNameTooltip) === null || _item$getDisplayNameT === void 0 ? void 0 : _item$getDisplayNameT.call(item, context),
        order: (_item$order = item.order) !== null && _item$order !== void 0 ? _item$order : 0
      };
    });
  }, [addPanelActions, createNewEmbeddableFromAction, canvasApi]);
  const getEditorMenuPanels = closePopover => [{
    id: 0,
    items: [...getAddPanelActionMenuItems(closePopover).sort((a, b) => b.order - a.order)]
  }];
  return /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarPopover, {
    ownFocus: true,
    label: strings.getEditorMenuButtonLabel(),
    panelPaddingSize: "none",
    "data-test-subj": "canvasEditorMenuButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, ({
    closePopover
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: getEditorMenuPanels(closePopover),
    "data-test-subj": "canvasEditorContextMenu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }));
};
exports.EditorMenu = EditorMenu;