"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomElementModal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lib = require("../../lib");
var _constants = require("../../../common/lib/constants");
var _element_card = require("../element_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/custom_element_modal/custom_element_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_NAME_LENGTH = 40;
const MAX_DESCRIPTION_LENGTH = 100;
const strings = {
  getCancelButtonLabel: () => _i18n.i18n.translate('xpack.canvas.customElementModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  getCharactersRemainingDescription: numberOfRemainingCharacter => _i18n.i18n.translate('xpack.canvas.customElementModal.remainingCharactersDescription', {
    defaultMessage: '{numberOfRemainingCharacter} characters remaining',
    values: {
      numberOfRemainingCharacter
    }
  }),
  getDescriptionInputLabel: () => _i18n.i18n.translate('xpack.canvas.customElementModal.descriptionInputLabel', {
    defaultMessage: 'Description'
  }),
  getElementPreviewTitle: () => _i18n.i18n.translate('xpack.canvas.customElementModal.elementPreviewTitle', {
    defaultMessage: 'Element preview'
  }),
  getImageFilePickerPlaceholder: () => _i18n.i18n.translate('xpack.canvas.customElementModal.imageFilePickerPlaceholder', {
    defaultMessage: 'Select or drag and drop an image'
  }),
  getImageInputDescription: () => _i18n.i18n.translate('xpack.canvas.customElementModal.imageInputDescription', {
    defaultMessage: 'Take a screenshot of your element and upload it here. This can also be done after saving.'
  }),
  getImageInputLabel: () => _i18n.i18n.translate('xpack.canvas.customElementModal.imageInputLabel', {
    defaultMessage: 'Thumbnail image'
  }),
  getNameInputLabel: () => _i18n.i18n.translate('xpack.canvas.customElementModal.nameInputLabel', {
    defaultMessage: 'Name'
  }),
  getSaveButtonLabel: () => _i18n.i18n.translate('xpack.canvas.customElementModal.saveButtonLabel', {
    defaultMessage: 'Save'
  })
};
class CustomElementModal extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      name: this.props.name || '',
      description: this.props.description || '',
      image: this.props.image || ''
    });
    (0, _defineProperty2.default)(this, "_handleChange", (type, value) => {
      this.setState({
        [type]: value
      });
    });
    (0, _defineProperty2.default)(this, "_handleUpload", files => {
      if (files == null) return;
      const file = files[0];
      const [type, subtype] = (0, _lodash.get)(file, 'type', '').split('/');
      if (type === 'image' && _constants.VALID_IMAGE_TYPES.indexOf(subtype) >= 0) {
        (0, _lib.encode)(file).then(dataurl => this._handleChange('image', dataurl));
      }
    });
  }
  render() {
    const {
      onSave,
      onCancel,
      title,
      ...rest
    } = this.props;
    const {
      name,
      description,
      image
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, (0, _extends2.default)({}, rest, {
      className: `canvasCustomElementModal`,
      maxWidth: 700,
      onClose: onCancel,
      initialFocus: ".canvasCustomElementForm__name",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      component: "h3",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 11
      }
    }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "flexStart",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "canvasCustomElementForm",
      grow: 2,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: strings.getNameInputLabel(),
      helpText: strings.getCharactersRemainingDescription(MAX_NAME_LENGTH - name.length),
      display: "rowCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: name,
      className: "canvasCustomElementForm__name",
      onChange: e => e.target.value.length <= MAX_NAME_LENGTH && this._handleChange('name', e.target.value),
      required: true,
      "data-test-subj": "canvasCustomElementForm-name",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: strings.getDescriptionInputLabel(),
      helpText: strings.getCharactersRemainingDescription(MAX_DESCRIPTION_LENGTH - description.length),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      value: description,
      rows: 2,
      onChange: e => e.target.value.length <= MAX_DESCRIPTION_LENGTH && this._handleChange('description', e.target.value),
      "data-test-subj": "canvasCustomElementForm-description",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      className: "canvasCustomElementForm__thumbnail",
      label: strings.getImageInputLabel(),
      display: "rowCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
      initialPromptText: strings.getImageFilePickerPlaceholder(),
      onChange: this._handleUpload,
      className: "canvasImageUpload",
      accept: "image/*",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      className: "canvasCustomElementForm__thumbnailHelp",
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 17
      }
    }, strings.getImageInputDescription()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "canvasElementCard__wrapper canvasCustomElementForm__preview",
      grow: 1,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 17
      }
    }, strings.getElementPreviewTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_element_card.ElementCard, {
      title: name,
      description: description,
      image: image,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: onCancel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 15
      }
    }, strings.getCancelButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: () => {
        onSave(name, description, image);
      },
      "data-test-subj": "canvasCustomElementForm-submit",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 15
      }
    }, strings.getSaveButtonLabel())))));
  }
}
exports.CustomElementModal = CustomElementModal;
(0, _defineProperty2.default)(CustomElementModal, "propTypes", {
  name: _propTypes.default.string,
  description: _propTypes.default.string,
  image: _propTypes.default.string,
  title: _propTypes.default.string.isRequired,
  onSave: _propTypes.default.func.isRequired,
  onCancel: _propTypes.default.func.isRequired
});