"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchCurrentPipelineTool = fetchCurrentPipelineTool;
var _messages = require("@langchain/core/messages");
var _tools = require("@langchain/core/tools");
var _langgraph = require("@langchain/langgraph");
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function fetchCurrentPipelineTool() {
  const schema = _zod.z.object({});
  return new _tools.DynamicStructuredTool({
    name: 'fetch_current_pipeline',
    description: 'Retrieves the current ingest pipeline stored in state. Use this to inspect the latest pipeline definition.',
    schema,
    func: async (_input, _runManager, config) => {
      var _state$current_pipeli, _config$toolCall;
      const state = (0, _langgraph.getCurrentTaskInput)();
      const currentPipeline = (_state$current_pipeli = state.current_pipeline) !== null && _state$current_pipeli !== void 0 ? _state$current_pipeli : {};
      const hasPipeline = Object.keys(currentPipeline).length > 0;
      return new _langgraph.Command({
        update: {
          messages: [new _messages.ToolMessage({
            content: JSON.stringify({
              current_pipeline: currentPipeline,
              has_pipeline: hasPipeline,
              message: hasPipeline ? 'Current pipeline retrieved successfully.' : 'No current pipeline available in state.'
            }),
            tool_call_id: config === null || config === void 0 ? void 0 : (_config$toolCall = config.toolCall) === null || _config$toolCall === void 0 ? void 0 : _config$toolCall.id
          })]
        }
      });
    }
  });
}