"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateAutoImportIntegrationRequestParams = exports.UpdateAutoImportIntegrationRequestBody = exports.GetAutoImportIntegrationResponse = exports.GetAutoImportIntegrationRequestParams = exports.GetAllAutoImportIntegrationsResponse = exports.DeleteAutoImportIntegrationRequestParams = exports.CreateAutoImportIntegrationResponse = exports.CreateAutoImportIntegrationRequestBody = void 0;
var _zod = require("@kbn/zod");
var _primitive = require("../../primitive.gen");
var _common_attributes = require("../../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Automatic Import Integrations API endpoint
 *   version: 1
 */

const CreateAutoImportIntegrationRequestBody = exports.CreateAutoImportIntegrationRequestBody = _zod.z.object({
  /**
   * The integration id
   */
  integrationId: _primitive.NonEmptyString,
  /**
   * The title of the integration
   */
  title: _primitive.NonEmptyString,
  /**
   * The description of the integration
   */
  description: _primitive.NonEmptyString,
  /**
   * The logo of the integration
   */
  logo: _primitive.NonEmptyString.optional(),
  /**
   * The data streams of the integration
   */
  dataStreams: _zod.z.array(_common_attributes.DataStream).optional()
}).strict();
const CreateAutoImportIntegrationResponse = exports.CreateAutoImportIntegrationResponse = _zod.z.object({
  /**
   * The integration id created in state.
   */
  integration_id: _primitive.NonEmptyString.optional()
}).strict();
const DeleteAutoImportIntegrationRequestParams = exports.DeleteAutoImportIntegrationRequestParams = _zod.z.object({
  /**
   * The integration identifier
   */
  integration_id: _primitive.NonEmptyString
});
const GetAllAutoImportIntegrationsResponse = exports.GetAllAutoImportIntegrationsResponse = _zod.z.array(_common_attributes.AllIntegrationsResponseIntegration);
const GetAutoImportIntegrationRequestParams = exports.GetAutoImportIntegrationRequestParams = _zod.z.object({
  /**
   * The integration identifier
   */
  integration_id: _primitive.NonEmptyString
});
const GetAutoImportIntegrationResponse = exports.GetAutoImportIntegrationResponse = _zod.z.object({
  integrationResponse: _common_attributes.IntegrationResponse
}).strict();
const UpdateAutoImportIntegrationRequestParams = exports.UpdateAutoImportIntegrationRequestParams = _zod.z.object({
  /**
   * The integration identifier
   */
  integration_id: _primitive.NonEmptyString
});
const UpdateAutoImportIntegrationRequestBody = exports.UpdateAutoImportIntegrationRequestBody = _zod.z.object({
  /**
   * Integration description
   */
  description: _primitive.NonEmptyString.optional(),
  /**
   * Integration logo image blob
   */
  logo: _primitive.NonEmptyString.optional(),
  /**
   * The data streams of the integration
   */
  dataStreams: _zod.z.array(_zod.z.object({
    /**
     * The description of the data stream
     */
    description: _primitive.NonEmptyString.optional(),
    /**
     * The input types of the data stream
     */
    inputTypes: _zod.z.array(_common_attributes.InputType).optional(),
    /**
     * The raw samples of the data stream
     */
    rawSamples: _zod.z.array(_primitive.NonEmptyString).optional()
  }).strict()).optional()
}).strict();