"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedAPIResponse = exports.EcsMappingAPIResponse = exports.CheckPipelineAPIResponse = exports.CelInputAPIResponse = exports.CategorizationAPIResponse = exports.AnalyzeLogsAPIResponse = exports.AnalyzeApiAPIResponse = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("./common_attributes.gen");
var _processor_attributes = require("./processor_attributes.gen");
var _cel_input_attributes = require("./cel_input_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Response Schemas.
 *   version: not applicable
 */

const EcsMappingAPIResponse = exports.EcsMappingAPIResponse = _zod.z.object({
  results: _zod.z.object({
    mapping: _common_attributes.Mapping,
    pipeline: _common_attributes.Pipeline
  })
});
const CategorizationAPIResponse = exports.CategorizationAPIResponse = _zod.z.object({
  results: _zod.z.object({
    docs: _common_attributes.Docs,
    pipeline: _common_attributes.Pipeline
  })
});
const RelatedAPIResponse = exports.RelatedAPIResponse = _zod.z.object({
  results: _zod.z.object({
    docs: _common_attributes.Docs,
    pipeline: _common_attributes.Pipeline
  })
});
const CheckPipelineAPIResponse = exports.CheckPipelineAPIResponse = _zod.z.object({
  results: _zod.z.object({
    docs: _common_attributes.Docs
  })
});
const AnalyzeLogsAPIResponse = exports.AnalyzeLogsAPIResponse = _zod.z.object({
  additionalProcessors: _zod.z.array(_processor_attributes.ESProcessorItem).optional(),
  results: _zod.z.object({
    samplesFormat: _common_attributes.SamplesFormat,
    parsedSamples: _zod.z.array(_zod.z.string())
  })
});
const CelInputAPIResponse = exports.CelInputAPIResponse = _zod.z.object({
  results: _cel_input_attributes.GeneratedCelDetails
});
const AnalyzeApiAPIResponse = exports.AnalyzeApiAPIResponse = _zod.z.object({
  results: _zod.z.object({
    suggestedPaths: _zod.z.array(_zod.z.string())
  })
});