"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNonDataStreamIndices = getNonDataStreamIndices;
var _get_indices = require("./get_indices");
var _compact_map = require("../../../utils/compact_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getNonDataStreamIndices({
  esClient,
  apmIndices
}) {
  const apmIndexPatterns = (0, _get_indices.getApmIndexPatterns)([apmIndices.error, apmIndices.metric, apmIndices.span, apmIndices.transaction]);

  // TODO: indices already retrieved by `getIndicesAndIngestPipelines`
  const nonDataStreamIndicesResponse = await esClient.indices.get({
    index: apmIndexPatterns,
    filter_path: ['*.data_stream', '*.settings.index.uuid'],
    ignore_unavailable: true
  });
  const nonDataStreamIndices = (0, _compact_map.compactMap)(Object.entries(nonDataStreamIndicesResponse), ([indexName, {
    data_stream: dataStream
  }]) => {
    if (!dataStream) {
      return indexName;
    }
  });
  return nonDataStreamIndices;
}