"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmIndexPatterns = getApmIndexPatterns;
exports.getIndicesAndIngestPipelines = getIndicesAndIngestPipelines;
var _compact_map = require("../../../utils/compact_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getApmIndexPatterns(indices) {
  return Array.from(new Set(indices.flatMap(index => index.split(','))));
}
async function getIndicesAndIngestPipelines({
  esClient,
  apmIndices
}) {
  const indices = await esClient.indices.get({
    index: getApmIndexPatterns([apmIndices.error, apmIndices.metric, apmIndices.span, apmIndices.transaction]),
    filter_path: ['*.settings.index.default_pipeline', '*.data_stream', '*.settings.index.provided_name'],
    ignore_unavailable: true
  });
  const pipelineIds = Array.from(new Set((0, _compact_map.compactMap)(Object.values(indices), index => {
    var _index$settings, _index$settings$index;
    return (_index$settings = index.settings) === null || _index$settings === void 0 ? void 0 : (_index$settings$index = _index$settings.index) === null || _index$settings$index === void 0 ? void 0 : _index$settings$index.default_pipeline;
  })));
  const ingestPipelines = await esClient.ingest.getPipeline({
    id: pipelineIds.join(','),
    filter_path: ['*.processors.grok.field', '*.processors.grok.patterns']
  });
  return {
    indices,
    ingestPipelines
  };
}