"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransactionDurationChartPreview = getTransactionDurationChartPreview;
var _server = require("@kbn/observability-plugin/server");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _apm_rule_types = require("../../../../../common/rules/apm_rule_types");
var _apm = require("../../../../../common/es_fields/apm");
var _environment_query = require("../../../../../common/utils/environment_query");
var _transactions = require("../../../../lib/helpers/transactions");
var _average_or_percentile_agg = require("./average_or_percentile_agg");
var _get_groupby_terms = require("../utils/get_groupby_terms");
var _get_all_groupby_fields = require("../../../../../common/rules/get_all_groupby_fields");
var _get_filtered_series_for_preview_chart = require("../utils/get_filtered_series_for_preview_chart");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getTransactionDurationChartPreview({
  alertParams,
  config,
  apmEventClient
}) {
  var _searchConfiguration$;
  const {
    aggregationType = _apm_rule_types.AggregationType.Avg,
    environment,
    serviceName,
    transactionType,
    transactionName,
    interval,
    start,
    end,
    groupBy: groupByFields,
    searchConfiguration
  } = alertParams;
  const searchAggregatedTransactions = await (0, _transactions.getSearchTransactionsEvents)({
    config,
    apmEventClient,
    kuery: ''
  });
  const termFilterQuery = !searchConfiguration ? [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName, {
    queryEmptyString: false
  }), ...(0, _server.termQuery)(_apm.TRANSACTION_TYPE, transactionType, {
    queryEmptyString: false
  }), ...(0, _server.termQuery)(_apm.TRANSACTION_NAME, transactionName, {
    queryEmptyString: false
  }), ...(0, _environment_query.environmentQuery)(environment)] : [];
  const query = {
    bool: {
      filter: [...termFilterQuery, ...(0, _server.getParsedFilterQuery)(searchConfiguration === null || searchConfiguration === void 0 ? void 0 : (_searchConfiguration$ = searchConfiguration.query) === null || _searchConfiguration$ === void 0 ? void 0 : _searchConfiguration$.query), ...(0, _server.rangeQuery)(start, end), ...(0, _transactions.getBackwardCompatibleDocumentTypeFilter)(searchAggregatedTransactions)]
    }
  };
  const transactionDurationField = (0, _transactions.getDurationFieldForTransactions)(searchAggregatedTransactions);
  const allGroupByFields = (0, _get_all_groupby_fields.getAllGroupByFields)(_ruleDataUtils.ApmRuleType.TransactionDuration, groupByFields);
  const aggs = {
    series: {
      multi_terms: {
        terms: (0, _get_groupby_terms.getGroupByTerms)(allGroupByFields),
        size: 1000
      },
      aggs: {
        timeseries: {
          date_histogram: {
            field: '@timestamp',
            fixed_interval: interval,
            min_doc_count: 0,
            extended_bounds: {
              min: start,
              max: end
            },
            ...(0, _average_or_percentile_agg.getMultiTermsSortOrder)(aggregationType)
          },
          aggs: {
            ...(0, _average_or_percentile_agg.averageOrPercentileAgg)({
              aggregationType,
              transactionDurationField
            })
          }
        }
      }
    }
  };
  const params = {
    apm: {
      events: [(0, _transactions.getProcessorEventForTransactions)(searchAggregatedTransactions)]
    },
    size: 0,
    track_total_hits: false,
    query,
    aggs
  };
  const resp = await apmEventClient.search('get_transaction_duration_chart_preview', params);
  if (!resp.aggregations) {
    return {
      series: [],
      totalGroups: 0
    };
  }
  const seriesDataMap = resp.aggregations.series.buckets.reduce((acc, bucket) => {
    const bucketKey = bucket.key.join('_');
    bucket.timeseries.buckets.forEach(timeseriesBucket => {
      const x = timeseriesBucket.key;
      const y = 'avgLatency' in timeseriesBucket ? timeseriesBucket.avgLatency.value : timeseriesBucket.pctLatency.values[0].value;
      if (acc[bucketKey]) {
        acc[bucketKey].push({
          x,
          y
        });
      } else {
        acc[bucketKey] = [{
          x,
          y
        }];
      }
    });
    return acc;
  }, {});
  const series = Object.keys(seriesDataMap).map(key => ({
    name: key,
    data: seriesDataMap[key]
  }));
  const filteredSeries = (0, _get_filtered_series_for_preview_chart.getFilteredBarSeries)(series);
  return {
    series: filteredSeries,
    totalGroups: series.length
  };
}