"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useApmRouter = useApmRouter;
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _react = require("react");
var _use_apm_plugin_context = require("../context/apm_plugin/use_apm_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useApmRouter({
  prependBasePath
} = {
  prependBasePath: true
}) {
  const router = (0, _typedReactRouterConfig.useRouter)();
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  return (0, _react.useMemo)(() => ({
    ...router,
    link: (...args) => prependBasePath ? core.http.basePath.prepend('/app/apm' + router.link(...args)) : router.link(...args)
  }), [core.http.basePath, prependBasePath, router]);
}