"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorMarks = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated Remove it once we remove the apm waterfall
 */
const getErrorMarks = errorItems => {
  if ((0, _lodash.isEmpty)(errorItems)) {
    return [];
  }
  return errorItems.map(error => ({
    type: 'errorMark',
    offset: Math.max(error.offset + error.skew, 0),
    verticalLine: false,
    id: error.id,
    error: error.doc,
    serviceColor: error.color
  }));
};
exports.getErrorMarks = getErrorMarks;