"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRequestBase = getRequestBase;
exports.processorEventsToIndex = processorEventsToIndex;
var _apmTypesShared = require("@kbn/apm-types-shared");
var _lodash = require("lodash");
var _es_fields = require("@kbn/apm-types/es_fields");
var _document_type = require("../document_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const processorEventIndexMap = {
  [_apmTypesShared.ProcessorEvent.transaction]: 'transaction',
  [_apmTypesShared.ProcessorEvent.span]: 'span',
  [_apmTypesShared.ProcessorEvent.metric]: 'metric',
  [_apmTypesShared.ProcessorEvent.error]: 'error'
};
function processorEventsToIndex(events, indices) {
  return (0, _lodash.uniq)(events.flatMap(event => indices[processorEventIndexMap[event]].split(',').map(str => str.trim())));
}
function getRequestBase(options) {
  const events = 'events' in options.apm ? options.apm.events : options.apm.sources.map(source => (0, _document_type.getProcessorEventForDocumentType)(source.documentType));
  const index = processorEventsToIndex(events, options.indices);
  const filters = options.skipProcessorEventFilter === true ? [] : [{
    terms: {
      [_es_fields.PROCESSOR_EVENT]: events
    }
  }];
  if ('sources' in options.apm) {
    options.apm.sources.forEach(source => {
      const documentTypeConfig = (0, _document_type.getConfigForDocumentType)(source.documentType);
      if ('getQuery' in documentTypeConfig) {
        filters.push(documentTypeConfig.getQuery(source.rollupInterval));
      }
    });
  }
  return {
    index,
    events,
    filters
  };
}