"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.combineFilterWithAuthorizationFilter = exports.buildTagsFilter = exports.buildRuleTypeIdsFilter = exports.buildFilter = exports.buildConsumersFilter = exports.NodeBuilderOperators = void 0;
exports.combineFilters = combineFilters;
var _esQuery = require("@kbn/es-query");
var _ = require("../..");
var _saved_objects = require("../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NodeBuilderOperators = exports.NodeBuilderOperators = {
  and: 'and',
  or: 'or'
};
const buildFilter = ({
  filters,
  field,
  operator,
  type
}) => {
  if (filters === undefined) {
    return;
  }
  const filtersAsArray = Array.isArray(filters) ? filters : [filters];
  if (filtersAsArray.length === 0) {
    return;
  }
  return _esQuery.nodeBuilder[operator](filtersAsArray.map(filter => _esQuery.nodeBuilder.is(`${type}.attributes.${field}`, filter)));
};
exports.buildFilter = buildFilter;
const buildRuleTypeIdsFilter = (ruleTypeIds, type = _.RULE_SAVED_OBJECT_TYPE) => {
  if (!ruleTypeIds || !(ruleTypeIds !== null && ruleTypeIds !== void 0 && ruleTypeIds.length)) {
    return;
  }

  // why???
  const field = type === _saved_objects.RULE_TEMPLATE_SAVED_OBJECT_TYPE ? 'ruleTypeId' : 'alertTypeId';
  return buildFilter({
    filters: ruleTypeIds,
    field,
    operator: 'or',
    type
  });
};
exports.buildRuleTypeIdsFilter = buildRuleTypeIdsFilter;
const buildConsumersFilter = (consumers, type = _.RULE_SAVED_OBJECT_TYPE) => {
  if (!consumers || !(consumers !== null && consumers !== void 0 && consumers.length)) {
    return;
  }
  return buildFilter({
    filters: consumers,
    field: 'consumer',
    operator: 'or',
    type
  });
};
exports.buildConsumersFilter = buildConsumersFilter;
const buildTagsFilter = (tags, type = _.RULE_SAVED_OBJECT_TYPE) => {
  if (!tags || !(tags !== null && tags !== void 0 && tags.length)) {
    return;
  }
  return buildFilter({
    filters: tags,
    field: 'tags',
    operator: 'or',
    type
  });
};

/**
 * Combines Kuery nodes and accepts an array with a mixture of undefined and KueryNodes. This will filter out the undefined
 * filters and return a KueryNode with the filters combined using the specified operator which defaults to and if not defined.
 */
exports.buildTagsFilter = buildTagsFilter;
function combineFilters(nodes, operator = NodeBuilderOperators.and) {
  const filters = nodes.filter(Boolean);
  if (filters.length <= 0) {
    return;
  }
  return _esQuery.nodeBuilder[operator](filters);
}
const combineFilterWithAuthorizationFilter = (filter, authorizationFilter) => {
  if (!filter && !authorizationFilter) {
    return;
  }
  const kueries = [...(filter !== undefined ? [filter] : []), ...(authorizationFilter !== undefined ? [authorizationFilter] : [])];
  return _esQuery.nodeBuilder.and(kueries);
};
exports.combineFilterWithAuthorizationFilter = combineFilterWithAuthorizationFilter;