"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetAlertIndicesAliasFn = createGetAlertIndicesAliasFn;
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
var _resource_installer_utils = require("../alerts_service/resource_installer_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createGetAlertIndicesAliasFn(ruleTypeRegistry) {
  return (rulesTypes, spaceId) => {
    const aliases = new Set();
    rulesTypes.forEach(ruleTypeId => {
      var _ruleType$alerts;
      const ruleType = ruleTypeRegistry.get(ruleTypeId);
      if ((_ruleType$alerts = ruleType.alerts) !== null && _ruleType$alerts !== void 0 && _ruleType$alerts.context) {
        var _ruleType$alerts2, _ruleType$alerts3;
        const indexTemplateAndPattern = (0, _resource_installer_utils.getIndexTemplateAndPattern)({
          context: (_ruleType$alerts2 = ruleType.alerts) === null || _ruleType$alerts2 === void 0 ? void 0 : _ruleType$alerts2.context,
          namespace: (_ruleType$alerts3 = ruleType.alerts) !== null && _ruleType$alerts3 !== void 0 && _ruleType$alerts3.isSpaceAware && spaceId ? spaceId : _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING
        });
        aliases.add(indexTemplateAndPattern.alias);
      }
    });
    return Array.from(aliases);
  };
}