"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkMarkApiKeysForInvalidation = void 0;
var _apmUtils = require("@kbn/apm-utils");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkMarkApiKeysForInvalidation = async ({
  apiKeys
}, logger, savedObjectsClient) => {
  await (0, _apmUtils.withSpan)({
    name: 'bulkMarkApiKeysForInvalidation',
    type: 'rules'
  }, async () => {
    if (apiKeys.length === 0) {
      return;
    }
    try {
      const apiKeyIds = apiKeys.map(apiKey => Buffer.from(apiKey, 'base64').toString().split(':')[0]);
      await savedObjectsClient.bulkCreate(apiKeyIds.map(apiKeyId => ({
        attributes: {
          apiKeyId,
          createdAt: new Date().toISOString()
        },
        type: _.API_KEY_PENDING_INVALIDATION_TYPE
      })));
    } catch (e) {
      logger.error(`Failed to bulk mark list of API keys [${apiKeys.map(key => `"${key}"`).join(', ')}] for invalidation: ${e.message}`, {
        error: {
          stack_trace: e.stack
        }
      });
    }
  });
};
exports.bulkMarkApiKeysForInvalidation = bulkMarkApiKeysForInvalidation;